/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class EnvironmentVariableJavaHomeInstallationSupplier
implements InstallationSupplier {
    private final ToolchainConfiguration buildOptions;

    public EnvironmentVariableJavaHomeInstallationSupplier(ToolchainConfiguration buildOptions) {
        this.buildOptions = buildOptions;
    }

    @Override
    public String getSourceName() {
        return "environment variable 'JAVA_HOME'";
    }

    @Override
    public Set<InstallationLocation> get() {
        String javaHomePath = this.buildOptions.getEnvironmentVariableValue("JAVA_HOME");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            return Collections.emptySet();
        }
        File javaHome = new File(javaHomePath);
        InstallationLocation installationLocation = InstallationLocation.userDefined(javaHome, this.getSourceName());
        return Collections.singleton(installationLocation);
    }
}

