﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitectedRequest.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WellArchitected {
namespace Model {

/**
 */
class UpgradeReviewTemplateLensReviewRequest : public WellArchitectedRequest {
 public:
  AWS_WELLARCHITECTED_API UpgradeReviewTemplateLensReviewRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpgradeReviewTemplateLensReview"; }

  AWS_WELLARCHITECTED_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the review template.</p>
   */
  inline const Aws::String& GetTemplateArn() const { return m_templateArn; }
  inline bool TemplateArnHasBeenSet() const { return m_templateArnHasBeenSet; }
  template <typename TemplateArnT = Aws::String>
  void SetTemplateArn(TemplateArnT&& value) {
    m_templateArnHasBeenSet = true;
    m_templateArn = std::forward<TemplateArnT>(value);
  }
  template <typename TemplateArnT = Aws::String>
  UpgradeReviewTemplateLensReviewRequest& WithTemplateArn(TemplateArnT&& value) {
    SetTemplateArn(std::forward<TemplateArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetLensAlias() const { return m_lensAlias; }
  inline bool LensAliasHasBeenSet() const { return m_lensAliasHasBeenSet; }
  template <typename LensAliasT = Aws::String>
  void SetLensAlias(LensAliasT&& value) {
    m_lensAliasHasBeenSet = true;
    m_lensAlias = std::forward<LensAliasT>(value);
  }
  template <typename LensAliasT = Aws::String>
  UpgradeReviewTemplateLensReviewRequest& WithLensAlias(LensAliasT&& value) {
    SetLensAlias(std::forward<LensAliasT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetClientRequestToken() const { return m_clientRequestToken; }
  inline bool ClientRequestTokenHasBeenSet() const { return m_clientRequestTokenHasBeenSet; }
  template <typename ClientRequestTokenT = Aws::String>
  void SetClientRequestToken(ClientRequestTokenT&& value) {
    m_clientRequestTokenHasBeenSet = true;
    m_clientRequestToken = std::forward<ClientRequestTokenT>(value);
  }
  template <typename ClientRequestTokenT = Aws::String>
  UpgradeReviewTemplateLensReviewRequest& WithClientRequestToken(ClientRequestTokenT&& value) {
    SetClientRequestToken(std::forward<ClientRequestTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateArn;

  Aws::String m_lensAlias;

  Aws::String m_clientRequestToken;
  bool m_templateArnHasBeenSet = false;
  bool m_lensAliasHasBeenSet = false;
  bool m_clientRequestTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
