/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class VerticaSequence
extends GenericSequence
implements GenericScriptObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(VerticaSequence.class);
    private String name;
    private String identityTableName;
    private long cacheCount;
    private boolean isCycle;
    private final VerticaSchema schema;
    private String description;
    private String source;

    public VerticaSequence(GenericStructContainer container, String name, String description, Number lastValue, Number minValue, Number maxValue, Number incrementBy, String identityTableName, long cacheCount, boolean isCycle) {
        super(container, name, description, lastValue, minValue, maxValue, incrementBy);
        this.name = name;
        this.identityTableName = identityTableName;
        this.cacheCount = cacheCount;
        this.isCycle = isCycle;
        this.schema = (VerticaSchema)container.getSchema();
        this.description = description;
    }

    public VerticaSequence(@NotNull GenericStructContainer container, @NotNull String name) {
        super(container, name);
        this.schema = (VerticaSchema)container.getSchema();
        this.cacheCount = 25000L;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, order=11)
    public GenericTableBase getIdentityTableName(DBRProgressMonitor monitor) {
        GenericTableBase table = null;
        if (CommonUtils.isEmpty((String)this.identityTableName)) {
            return null;
        }
        try {
            table = this.schema.getTable(monitor, this.identityTableName);
        }
        catch (DBException e) {
            log.debug((Object)"Can't find identity table", (Throwable)e);
        }
        return table;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    public Long getLastValue() {
        return super.getLastValue().longValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    public Long getMinValue() {
        return super.getMinValue().longValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    public Long getMaxValue() {
        return super.getMaxValue().longValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public Long getIncrementBy() {
        return super.getIncrementBy().longValue();
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public long getCacheCount() {
        return this.cacheCount;
    }

    public void setCacheCount(long cacheCount) {
        this.cacheCount = cacheCount;
    }

    @Property(viewable=true, editable=true, updatable=true, order=8)
    public boolean isCycle() {
        return this.isCycle;
    }

    public void setCycle(boolean cycle) {
        this.isCycle = cycle;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, editable=true, updatable=true, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        if (this.source == null) {
            if (!this.isPersisted()) {
                this.source = "CREATE SEQUENCE " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
            } else {
                StringBuilder ddl = new StringBuilder();
                ddl.append("CREATE SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DML)).append("\n\tINCREMENT BY ").append(this.getIncrementBy()).append("\n\tMINVALUE ").append(this.getMinValue()).append("\n\tMAXVALUE ").append(this.getMaxValue());
                if (this.getLastValue() != null) {
                    ddl.append("\n\tSTART WITH ").append(this.getLastValue());
                }
                if (this.cacheCount <= 1L) {
                    ddl.append("\n\tNO CACHE");
                } else {
                    ddl.append("\n\tCACHE ").append(this.cacheCount);
                }
                ddl.append("\n\t").append(this.isCycle ? "" : "NO ").append("CYCLE;");
                if (!CommonUtils.isEmpty((String)this.description)) {
                    ddl.append("\n\nCOMMENT ON SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.description)).append(";");
                }
                this.source = ddl.toString();
            }
        }
        return this.source;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.source = null;
        return this;
    }
}

