/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.SharpEdgeView;
import org.freeplane.view.swing.map.link.CollisionDetector;

public class SharpLinearEdgeView
extends SharpEdgeView {
    public SharpLinearEdgeView(NodeView source, NodeView target, Component paintedComponent, boolean highlightsAscendantEdge) {
        super(source, target, paintedComponent, highlightsAscendantEdge);
    }

    @Override
    public Stroke getStroke() {
        return this.getStroke(0.0f);
    }

    @Override
    protected void draw(Graphics2D g) {
        int deltaX = this.getDeltaX();
        int deltaY = this.getDeltaY();
        if (this.start != this.shapeStart) {
            int[] xs = new int[]{this.start.x, this.shapeStart.x + deltaX, this.end.x, this.shapeStart.x - deltaX};
            int[] ys = new int[]{this.start.y, this.shapeStart.y + deltaY, this.end.y, this.shapeStart.y - deltaY};
            g.fillPolygon(xs, ys, 4);
        } else {
            int[] xs = new int[]{this.shapeStart.x + deltaX, this.end.x, this.shapeStart.x - deltaX};
            int[] ys = new int[]{this.shapeStart.y + deltaY, this.end.y, this.shapeStart.y - deltaY};
            g.fillPolygon(xs, ys, 3);
        }
    }

    @Override
    public boolean detectCollision(Point p) {
        Polygon polygon;
        int w = this.getMap().getZoomed(this.getWidth() / 2 + 1);
        if (this.start != this.shapeStart) {
            int[] xs = new int[]{this.start.x, this.shapeStart.x, this.end.x, this.shapeStart.x, this.start.x};
            int[] ys = new int[]{this.start.y, this.shapeStart.y, this.end.y, this.shapeStart.y, this.start.y};
            polygon = new Polygon(xs, ys, 5);
        } else {
            int[] xs = new int[]{this.start.x, this.end.x, this.start.x};
            int[] ys = new int[]{this.start.y + w, this.end.y, this.start.y - w};
            polygon = new Polygon(xs, ys, 3);
        }
        return new CollisionDetector().detectCollision(p, polygon);
    }
}

