/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.SystemUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import resources.ResourceManager;

public class HelpLocation {
    public static final String HELP_TOPICS = "help/topics/";
    public static final String HELP_SHARED = "help/shared/";
    private String id;
    private URL url;
    private String topic;
    private String anchor;
    private String inceptionInformation;
    private boolean urlInitialized;

    public HelpLocation(String topic, String anchor) {
        this(topic, anchor, HelpLocation.createInception());
    }

    public HelpLocation(String topic, String anchor, String inceptionInformation) {
        if (topic == null) {
            topic = "UnknownTopic";
        }
        anchor = HelpLocation.fixString(anchor, false);
        this.topic = topic;
        this.anchor = anchor;
        this.id = this.buildId(topic, anchor);
        this.inceptionInformation = inceptionInformation;
    }

    private URL getURL() {
        if (!this.urlInitialized) {
            this.urlInitialized = true;
            this.url = this.buildURL(this.topic, this.anchor);
        }
        return this.url;
    }

    private static String fixString(String str, boolean allowFilePath) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str);
        int n = buf.length();
        for (int i = 0; i < n; ++i) {
            char c = buf.charAt(i);
            if (allowFilePath && (c == '.' || c == '/') || Character.isLetterOrDigit(c)) continue;
            buf.setCharAt(i, '_');
        }
        return buf.toString();
    }

    private String buildId(String localTopic, String localAnchor) {
        if (localTopic.indexOf(".htm") >= 0) {
            return null;
        }
        if (localAnchor == null) {
            return localTopic;
        }
        int ix = localAnchor.indexOf(".htm");
        if (ix >= 0) {
            localAnchor = localAnchor.substring(0, ix);
        }
        localTopic = HelpLocation.fixString(localTopic, false);
        return localTopic + "_" + localAnchor;
    }

    private URL buildURL(String localTopic, String localAnchor) {
        String topicPath = HelpLocation.fixString(localTopic, true);
        URL localURL = this.findHelpResource(topicPath);
        if (localURL != null && localAnchor != null) {
            try {
                localURL = new URL(localURL.toExternalForm() + "#" + localAnchor);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return localURL;
    }

    private URL findHelpResource(String topicPath) {
        if (topicPath.indexOf(".htm") >= 0) {
            return ResourceManager.getResource("/help/topics/" + topicPath);
        }
        String filename = topicPath + ".htm";
        URL fileURL = ResourceManager.getResource("/help/topics/" + filename);
        if (fileURL != null) {
            return fileURL;
        }
        filename = topicPath + ".html";
        fileURL = ResourceManager.getResource("/help/topics/" + filename);
        if (fileURL != null) {
            return fileURL;
        }
        return null;
    }

    public String getHelpId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public URL getHelpURL() {
        return this.getURL();
    }

    public String toString() {
        URL helpURL = this.getURL();
        if (helpURL != null) {
            return helpURL.toString();
        }
        if (this.id != null) {
            return this.id;
        }
        return "<Unknown>";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anchor == null ? 0 : this.anchor.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        URL helpURL = this.getURL();
        result = 31 * result + (helpURL == null ? 0 : helpURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HelpLocation other = (HelpLocation)obj;
        if (this.anchor == null ? other.anchor != null : !this.anchor.equals(other.anchor)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        URL helpURL = this.getURL();
        return !(helpURL == null ? other.getURL() != null : !helpURL.equals(other.getURL()));
    }

    public String getInceptionInformation() {
        return this.inceptionInformation;
    }

    private static String createInception() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return null;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        String information = HelpLocation.getInceptionInformationFromTheFirstClassThatIsNotUs(stackTrace);
        return information;
    }

    private static String getInceptionInformationFromTheFirstClassThatIsNotUs(StackTraceElement[] stackTrace) {
        String myClassName = HelpLocation.class.getName();
        int myClassNameStartIndex = -1;
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (!myClassName.equals(elementClassName)) continue;
            myClassNameStartIndex = i;
            break;
        }
        int creatorIndex = myClassNameStartIndex;
        for (int i = myClassNameStartIndex; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (myClassName.equals(elementClassName)) continue;
            creatorIndex = i;
            break;
        }
        return stackTrace[creatorIndex].toString();
    }
}

