/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.cdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CDexCodeItem
extends CodeItem {
    public static final short kRegistersSizeShift = 12;
    public static final short kInsSizeShift = 8;
    public static final short kOutsSizeShift = 4;
    public static final short kTriesSizeSizeShift = 0;
    public static final short kInsnsSizeShift = 5;
    public static final short kBitPreHeaderRegisterSize = 0;
    public static final short kBitPreHeaderInsSize = 1;
    public static final short kBitPreHeaderOutsSize = 2;
    public static final short kBitPreHeaderTriesSize = 3;
    public static final short kBitPreHeaderInsnsSize = 4;
    public static final short kFlagPreHeaderRegisterSize = 1;
    public static final short kFlagPreHeaderInsSize = 2;
    public static final short kFlagPreHeaderOutsSize = 4;
    public static final short kFlagPreHeaderTriesSize = 8;
    public static final short kFlagPreHeaderInsnsSize = 16;
    public static final short kFlagPreHeaderCombined = 31;
    private short fields_;
    private short insns_count_and_flags_;

    public CDexCodeItem(BinaryReader reader) throws IOException {
        long startIndex = reader.getPointerIndex();
        this.fields_ = reader.readNextShort();
        this.registersSize = (short)(this.fields_ >> 12 & 0xF);
        this.incomingSize = (short)(this.fields_ >> 8 & 0xF);
        this.outgoingSize = (short)(this.fields_ >> 4 & 0xF);
        this.triesSize = (short)(this.fields_ >> 4 & 0xF);
        this.insns_count_and_flags_ = reader.readNextShort();
        this.instructionSize = Short.toUnsignedInt(this.insns_count_and_flags_) >> 5;
        if (this.hasPreHeader()) {
            if (this.hasPreHeader((short)16)) {
                this.instructionSize += reader.readShort(startIndex -= 2L);
                this.instructionSize += reader.readShort(startIndex -= 2L) << 16;
            }
            if (this.hasPreHeader((short)1)) {
                this.registersSize = (short)(this.registersSize + reader.readShort(startIndex -= 2L));
            }
            if (this.hasPreHeader((short)2)) {
                this.incomingSize = (short)(this.incomingSize + reader.readShort(startIndex -= 2L));
            }
            if (this.hasPreHeader((short)4)) {
                this.outgoingSize = (short)(this.outgoingSize + reader.readShort(startIndex -= 2L));
            }
            if (this.hasPreHeader((short)8)) {
                this.triesSize = (short)(this.triesSize + reader.readShort(startIndex -= 2L));
            }
        }
        if (this.getInstructionSize() == 0) {
            this.instructionBytes = new byte[0];
            this.instructions = new short[0];
        } else {
            this.instructionBytes = reader.readNextByteArray(this.getInstructionSize() * 2);
            this.instructions = reader.readNextShortArray(this.getInstructionSize());
        }
    }

    public boolean hasPreHeader() {
        return (this.insns_count_and_flags_ & 0x1F) != 0;
    }

    public boolean hasPreHeader(short flag) {
        return (this.insns_count_and_flags_ & flag) != 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "cdex_code_item_" + this.getInstructionSize() * 2;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(WORD, "fields_", null);
        structure.add(WORD, "insns_count_and_flags_", null);
        if (this.getInstructionSize() > 0) {
            structure.add((DataType)new ArrayDataType(WORD, this.getInstructionSize(), WORD.getLength()), "insns_", null);
        }
        structure.setCategoryPath(new CategoryPath("/dex/cdex_code_item"));
        return structure;
    }
}

