/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.Schema;
import db.Table;
import ghidra.program.database.module.ParentChildDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class ParentChildDBAdapterV0
extends ParentChildDBAdapter {
    static final int V0_VERSION = 0;
    static final int V0_PARENT_ID_COL = 0;
    static final int V0_CHILD_ID_COL = 1;
    static final int V0_ORDER_COL = 2;
    static final Schema V0_PARENT_CHILD_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE}, new String[]{"Parent ID", "Child ID", "Child Index"});
    private Table parentChildTable;

    public ParentChildDBAdapterV0(DBHandle handle, boolean create, long treeID) throws VersionException, IOException {
        String tableName = ParentChildDBAdapterV0.getTableName(treeID);
        if (create) {
            this.parentChildTable = handle.createTable(tableName, V0_PARENT_CHILD_SCHEMA, new int[]{0, 1});
        } else {
            this.parentChildTable = handle.getTable(tableName);
            if (this.parentChildTable == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.parentChildTable.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public DBRecord addParentChildRecord(long moduleID, long childID) throws IOException {
        DBRecord pcRec = V0_PARENT_CHILD_SCHEMA.createRecord(this.parentChildTable.getKey());
        pcRec.setLongValue(0, moduleID);
        pcRec.setLongValue(1, childID);
        this.parentChildTable.putRecord(pcRec);
        return pcRec;
    }

    @Override
    DBRecord getParentChildRecord(long parentID, long childID) throws IOException {
        Field[] keys = this.parentChildTable.findRecords((Field)new LongField(childID), 1);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord pcRec = this.parentChildTable.getRecord(keys[i]);
            if (pcRec.getLongValue(0) != parentID) continue;
            return pcRec;
        }
        return null;
    }

    @Override
    boolean removeParentChildRecord(long key) throws IOException {
        return this.parentChildTable.deleteRecord(key);
    }

    @Override
    DBRecord getParentChildRecord(long key) throws IOException {
        return this.parentChildTable.getRecord(key);
    }

    @Override
    void updateParentChildRecord(DBRecord record) throws IOException {
        this.parentChildTable.putRecord(record);
    }

    @Override
    Field[] getParentChildKeys(long parentID, int indexedCol) throws IOException {
        return this.parentChildTable.findRecords((Field)new LongField(parentID), indexedCol);
    }
}

