/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.rect;

import ghidra.util.database.spatial.rect.Rectangle2D;

public interface EuclideanSpace2D<X, Y> {
    public int compareX(X var1, X var2);

    public int compareY(Y var1, Y var2);

    public double distX(X var1, X var2);

    public double distY(Y var1, Y var2);

    public X midX(X var1, X var2);

    public Y midY(Y var1, Y var2);

    default public X minX(X x1, X x2) {
        return this.compareX(x1, x2) < 0 ? x1 : x2;
    }

    default public X maxX(X x1, X x2) {
        return this.compareX(x1, x2) > 0 ? x1 : x2;
    }

    default public Y minY(Y y1, Y y2) {
        return this.compareY(y1, y2) < 0 ? y1 : y2;
    }

    default public Y maxY(Y y1, Y y2) {
        return this.compareY(y1, y2) > 0 ? y1 : y2;
    }

    public Rectangle2D<X, Y, ?> getFull();
}

