---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Git basics.
title: 'Tutorials: Learn Git'
---

GitLab is a Git-based platform, so understanding Git is important to get
the most out of GitLab.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [Make your first Git commit](make_first_git_commit/_index.md) | Create a project, edit a file, and commit changes to a Git repository from the command line. | {{< icon name="star" >}} |
| [Introduction to Git](https://university.gitlab.com/courses/introduction-to-git) | Learn the basics of Git in this self-paced course. | {{< icon name="star" >}} |
| [Take advantage of Git rebase](https://about.gitlab.com/blog/2022/10/06/take-advantage-of-git-rebase/) | Learn how to use the `rebase` command in your workflow. | |
| [Update Git commit messages](update_commit_messages/_index.md) | Learn how to update commit messages and push the changes to GitLab. | |
| [Update Git remote URLs](update_git_remote_url/_index.md) | Learn how to update the Git remote URLs in your local project when they have changed. | |
| [Git cheat sheet](https://about.gitlab.com/images/press/git-cheat-sheet.pdf) | Download a PDF of common Git commands. | |
