/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.dm;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.serialize.codecs.dm.FixedFileArtifactSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lorg/gradle/internal/serialize/codecs/dm/CollectingArtifactVisitor;", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ArtifactVisitor;", "<init>", "()V", "elements", "", "", "getElements", "()Ljava/util/List;", "artifacts", "", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvableArtifact;", "getArtifacts", "()Ljava/util/Set;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "requireArtifactFiles", "", "visitFailure", "", "failure", "", "visitArtifact", "artifactSetName", "Lorg/gradle/internal/DisplayName;", "sourceVariantId", "Lorg/gradle/internal/component/model/VariantIdentifier;", "attributes", "Lorg/gradle/api/internal/attributes/ImmutableAttributes;", "capabilities", "Lorg/gradle/internal/component/external/model/ImmutableCapabilities;", "artifact", "endVisitCollection", "dependency-management-serialization-codecs"})
final class CollectingArtifactVisitor
implements ArtifactVisitor {
    @NotNull
    private final List<Object> elements = new ArrayList();
    @NotNull
    private final Set<ResolvableArtifact> artifacts = new LinkedHashSet();

    @NotNull
    public final List<Object> getElements() {
        return this.elements;
    }

    @NotNull
    public final Set<ResolvableArtifact> getArtifacts() {
        return this.artifacts;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source instanceof TransformedArtifactSet ? FileCollectionStructureVisitor.VisitType.NoContents : FileCollectionStructureVisitor.VisitType.Visit;
    }

    public boolean requireArtifactFiles() {
        return true;
    }

    public void visitFailure(@NotNull Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.elements.add(failure);
    }

    public void visitArtifact(@NotNull DisplayName artifactSetName, @NotNull VariantIdentifier sourceVariantId, @NotNull ImmutableAttributes attributes, @NotNull ImmutableCapabilities capabilities, @NotNull ResolvableArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifactSetName, (String)"artifactSetName");
        Intrinsics.checkNotNullParameter((Object)sourceVariantId, (String)"sourceVariantId");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (this.artifacts.add(artifact)) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifact.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"getId(...)");
            File file = artifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            this.elements.add(new FixedFileArtifactSpec(componentArtifactIdentifier, sourceVariantId, attributes, capabilities, artifactSetName, file));
        }
    }

    public void endVisitCollection(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof TransformedArtifactSet) {
            this.elements.add(source);
        }
    }
}

