# Copyright (C) 2014-2023 by the Free Software Foundation, Inc.
#
# This file is part of GNU Mailman.
#
# GNU Mailman is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# GNU Mailman is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# GNU Mailman.  If not, see <http://www.gnu.org/licenses/>.

"""Test Postfix config."""

import unittest

from mailman.config import config
from mailman.mta.postfix import LMTP
from mailman.testing.layers import ConfigLayer


class TestPostfixConfig(unittest.TestCase):
    layer = ConfigLayer

    def test_regex_config(self):
        config.push('regex_config', """\
[mta]
configuration: python:mailman.mta.tests.data.postfix
""")
        lmtp = LMTP()
        self.assertEqual('regex', lmtp.transport_file_type)
        config.pop('regex_config')
