/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.ejt.internal.gui.HiDPIUtil;
import com.install4j.api.styles.StyleContext;
import com.install4j.api.styles.StyleContextReceiver;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ContentComponent
extends SystemFormComponent
implements StyleContextReceiver {
    private JPanel containerPanel;
    private JComponent content;

    public void setContent(JComponent content) {
        if (this.content != content || content.getParent() == null) {
            this.content = content;
            this.containerPanel.removeAll();
            this.containerPanel.add((Component)content, "Center");
        }
    }

    @Override
    public void setStyleContext(StyleContext styleContext) {
        JComponent contentComponent = styleContext.getContentComponent();
        if (contentComponent != null && contentComponent.getParent() == null) {
            this.setContent(contentComponent);
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.containerPanel = new JPanel(new BorderLayout());
        if (this.getFormEnvironment().isDesignTime()) {
            this.containerPanel.add((Component)new PlaceholderComponent(), "Center");
        }
        return this.containerPanel;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean isFillCenterVertical() {
        return true;
    }

    private static class PlaceholderComponent
    extends JPanel {
        private int lastCrossHatch;
        private BufferedImage bufferedImage;

        public PlaceholderComponent() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            JLabel label = new JLabel("Screen Content");
            label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            label.setEnabled(false);
            label.setOpaque(true);
            this.add((Component)label, gc);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int crossHatch;
            Graphics2D g2 = (Graphics2D)graphics;
            double scaleFactor = HiDPIUtil.getScaleFactor(g2);
            if (scaleFactor > 1.0) {
                double inverseScaleFactor = 1.0 / scaleFactor;
                g2.scale(inverseScaleFactor, inverseScaleFactor);
            }
            if ((crossHatch = (int)(10.0 * HiDPIUtil.getScaleFactor(g2))) != this.lastCrossHatch) {
                this.lastCrossHatch = crossHatch;
                this.bufferedImage = this.initCrossHatchImage(crossHatch);
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, crossHatch, crossHatch);
            g2.setPaint(new TexturePaint(this.bufferedImage, rect));
            g2.fill(new Rectangle2D.Double(0.0, 0.0, (double)this.getWidth() * scaleFactor, (double)this.getHeight() * scaleFactor));
            if (scaleFactor > 1.0) {
                g2.scale(scaleFactor, scaleFactor);
            }
        }

        private BufferedImage initCrossHatchImage(int crossHatch) {
            BufferedImage bufferedImage = new BufferedImage(crossHatch, crossHatch, 2);
            Graphics2D g2 = bufferedImage.createGraphics();
            Color hatchColor = UIManager.getColor("Label.disabledForeground");
            g2.setColor(hatchColor);
            g2.drawLine(0, 0, crossHatch, crossHatch);
            return bufferedImage;
        }
    }
}

