/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import java.util.concurrent.TimeUnit;

public class FFmpegProgress {
    private final Long frame;
    private final Double fps;
    private final Double q;
    private final Long size;
    private final Long timeMicros;
    private final Long dup;
    private final Long drop;
    private final Double bitrate;
    private final Double speed;

    public FFmpegProgress(Long frame, Double fps, Double q, Long size, Long timeMicros, Long dup, Long drop, Double bitrate, Double speed) {
        this.frame = frame;
        this.fps = fps;
        this.q = q;
        this.size = size;
        this.timeMicros = timeMicros;
        this.dup = dup;
        this.drop = drop;
        this.bitrate = bitrate;
        this.speed = speed;
    }

    public Long getFrame() {
        return this.frame;
    }

    public Double getFps() {
        return this.fps;
    }

    public Double getQ() {
        return this.q;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getTimeMillis() {
        return this.getTime(TimeUnit.MILLISECONDS);
    }

    public Long getTimeMicros() {
        return this.timeMicros;
    }

    public Long getTime(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit must be non null");
        }
        if (this.timeMicros == null) {
            return null;
        }
        return timeUnit.convert(this.timeMicros, TimeUnit.MICROSECONDS);
    }

    public Long getDup() {
        return this.dup;
    }

    public Long getDrop() {
        return this.drop;
    }

    public Double getBitrate() {
        return this.bitrate;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public String toString() {
        return "FFmpegProgress{frame=" + this.frame + ", fps=" + this.fps + ", q=" + this.q + ", size=" + this.size + ", timeMicros=" + this.timeMicros + ", dup=" + this.dup + ", drop=" + this.drop + ", bitrate=" + this.bitrate + ", speed=" + this.speed + '}';
    }
}

