/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.stats;

import java.util.Comparator;
import java.util.Locale;
import org.opensearch.wlm.stats.WlmStats;

public enum SortBy {
    WORKLOAD_GROUP{

        @Override
        public Comparator<WlmStats> getComparator() {
            return Comparator.comparing(wlmStats -> {
                if (wlmStats.getWorkloadGroupStats() == null || wlmStats.getWorkloadGroupStats().getStats() == null || wlmStats.getWorkloadGroupStats().getStats().isEmpty()) {
                    return "";
                }
                return wlmStats.getWorkloadGroupStats().getStats().keySet().iterator().next();
            }).thenComparing(wlmStats -> {
                if (wlmStats.getNode() == null || wlmStats.getNode().getId() == null) {
                    return "";
                }
                return wlmStats.getNode().getId();
            });
        }
    }
    ,
    NODE_ID{

        @Override
        public Comparator<WlmStats> getComparator() {
            return Comparator.comparing(wlmStats -> {
                if (wlmStats.getNode() == null || wlmStats.getNode().getId() == null) {
                    return "";
                }
                return wlmStats.getNode().getId();
            }).thenComparing(wlmStats -> {
                if (wlmStats.getWorkloadGroupStats() == null || wlmStats.getWorkloadGroupStats().getStats() == null || wlmStats.getWorkloadGroupStats().getStats().isEmpty()) {
                    return "";
                }
                return wlmStats.getWorkloadGroupStats().getStats().keySet().iterator().next();
            });
        }
    };


    public abstract Comparator<WlmStats> getComparator();

    public static SortBy fromString(String input) {
        try {
            return SortBy.valueOf(input.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid sort field: " + input + ". Allowed values: workload_group, node_id");
        }
    }
}

