/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.preprocessor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.preprocessor.ImputePreprocessor;
import com.amazon.randomcutforest.preprocessor.InitialSegmentPreprocessor;
import com.amazon.randomcutforest.preprocessor.transform.DifferenceTransformer;
import com.amazon.randomcutforest.preprocessor.transform.ITransformer;
import com.amazon.randomcutforest.preprocessor.transform.NormalizedDifferenceTransformer;
import com.amazon.randomcutforest.preprocessor.transform.NormalizedTransformer;
import com.amazon.randomcutforest.preprocessor.transform.SubtractMATransformer;
import com.amazon.randomcutforest.preprocessor.transform.WeightedTransformer;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.statistics.Deviation;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class Preprocessor
implements IPreprocessor {
    public static double NORMALIZATION_SCALING_FACTOR = 2.0;
    public static double DEFAULT_NORMALIZATION_PRECISION = 0.001;
    public static int DEFAULT_START_NORMALIZATION = 10;
    public static int DEFAULT_STOP_NORMALIZATION = Integer.MAX_VALUE;
    public static int DEFAULT_CLIP_NORMALIZATION = 100;
    public static boolean DEFAULT_NORMALIZATION = false;
    public static boolean DEFAULT_DIFFERENCING = false;
    public static double DEFAULT_USE_IMPUTED_FRACTION = 0.5;
    public static int MINIMUM_OBSERVATIONS_FOR_EXPECTED = 100;
    public static int DEFAULT_DATA_QUALITY_STATES = 1;
    protected Deviation[] timeStampDeviations;
    protected boolean normalizeTime;
    protected double weightTime;
    protected double transformDecay;
    protected long[] previousTimeStamps;
    protected int internalTimeStamp = 0;
    protected double[][] initialValues;
    protected long[] initialTimeStamps;
    protected int startNormalization;
    protected Integer stopNormalization;
    protected int valuesSeen = 0;
    protected double[] defaultFill;
    protected double useImputedFraction = DEFAULT_USE_IMPUTED_FRACTION;
    protected int numberOfImputed;
    protected ImputationMethod imputationMethod = ImputationMethod.RCF;
    protected double clipFactor = DEFAULT_CLIP_NORMALIZATION;
    protected double[] lastShingledInput;
    protected float[] lastShingledPoint;
    protected TransformMethod transformMethod;
    protected int shingleSize;
    protected int dimension;
    protected int inputLength;
    protected ForestMode mode;
    protected Deviation[] dataQuality;
    protected ITransformer transformer;
    protected boolean fastForward = false;

    public Preprocessor(Builder<?> builder) {
        CommonUtils.checkArgument(builder.transformMethod != null, "transform required");
        CommonUtils.checkArgument(builder.forestMode != null, " forest mode is required");
        CommonUtils.checkArgument(builder.inputLength > 0, "incorrect input length");
        CommonUtils.checkArgument(builder.shingleSize > 0, "incorrect shingle size");
        CommonUtils.checkArgument(builder.dimensions > 0, "incorrect dimensions");
        CommonUtils.checkArgument(builder.shingleSize == 1 || builder.dimensions % builder.shingleSize == 0, " shingle size should divide the dimensions");
        CommonUtils.checkArgument(builder.forestMode != ForestMode.STREAMING_IMPUTE || builder.shingleSize > 1, "cannot impute a time series with shingle size 1");
        CommonUtils.checkArgument(builder.forestMode == ForestMode.TIME_AUGMENTED || builder.inputLength == builder.dimensions || builder.inputLength * builder.shingleSize == builder.dimensions, "incorrect input size");
        CommonUtils.checkArgument(builder.forestMode != ForestMode.TIME_AUGMENTED || (builder.inputLength + 1) * builder.shingleSize == builder.dimensions, "incorrect input size");
        CommonUtils.checkArgument(builder.startNormalization <= builder.stopNormalization, "incorrect normalization parameters");
        CommonUtils.checkArgument(builder.startNormalization > 0 || !builder.normalizeTime, " start of normalization cannot be 0");
        CommonUtils.checkArgument(builder.startNormalization > 0 || builder.transformMethod != TransformMethod.NORMALIZE, " start of normalization cannot be 0 for normalize");
        CommonUtils.checkArgument(builder.startNormalization > 0 || builder.transformMethod != TransformMethod.NORMALIZE_DIFFERENCE, " start of normalization cannot be 0 for normalized difference");
        CommonUtils.checkArgument(builder.weights == null || builder.weights.length >= builder.inputLength, " incorrect weights");
        if (builder.initialShingledInput != null) {
            CommonUtils.checkArgument(builder.initialShingledInput.length == builder.inputLength * builder.shingleSize, "incorrect length shingled input");
        }
        CommonUtils.checkArgument(builder.initialPoint == null || builder.initialPoint.length == builder.dimensions, "incorrect length shingled transformed point");
        this.inputLength = builder.inputLength;
        this.dimension = builder.dimensions;
        this.shingleSize = builder.shingleSize;
        this.mode = builder.forestMode;
        this.lastShingledPoint = builder.initialPoint == null ? new float[this.dimension] : Preprocessor.copyIfNotnull(builder.initialPoint);
        this.transformMethod = builder.transformMethod;
        this.startNormalization = builder.startNormalization;
        this.stopNormalization = builder.stopNormalization;
        this.normalizeTime = builder.normalizeTime;
        double[] weights = new double[this.inputLength];
        Arrays.fill(weights, 1.0);
        if (builder.weights != null) {
            if (builder.weights.length == this.inputLength) {
                System.arraycopy(builder.weights, 0, weights, 0, this.inputLength);
                this.weightTime = builder.weightTime;
            } else {
                System.arraycopy(builder.weights, 0, weights, 0, this.inputLength);
                this.weightTime = builder.weights[this.inputLength];
            }
        } else {
            this.weightTime = builder.weightTime;
        }
        this.previousTimeStamps = new long[this.shingleSize];
        this.lastShingledInput = this.inputLength == this.dimension ? (builder.initialShingledInput == null ? new double[this.dimension] : Arrays.copyOf(builder.initialShingledInput, this.dimension)) : (builder.initialShingledInput == null ? new double[this.shingleSize * this.inputLength] : Arrays.copyOf(builder.initialShingledInput, this.shingleSize * this.inputLength));
        this.transformDecay = builder.transformDecay;
        this.dataQuality = builder.dataQuality.orElse(new Deviation[]{new Deviation(this.transformDecay)});
        Deviation[] deviationList = new Deviation[WeightedTransformer.NUMBER_OF_STATS * this.inputLength];
        this.manageDeviations(deviationList, builder.deviations, this.transformDecay);
        this.timeStampDeviations = new Deviation[WeightedTransformer.NUMBER_OF_STATS];
        this.manageDeviations(this.timeStampDeviations, builder.timeDeviations, this.transformDecay);
        if (this.transformMethod == TransformMethod.NONE) {
            for (int i = 0; i < this.inputLength; ++i) {
                CommonUtils.checkArgument(weights[i] == 1.0, "incorrect weights");
            }
            this.transformer = new WeightedTransformer(weights, deviationList);
        } else {
            this.transformer = this.transformMethod == TransformMethod.WEIGHTED ? new WeightedTransformer(weights, deviationList) : (this.transformMethod == TransformMethod.DIFFERENCE ? new DifferenceTransformer(weights, deviationList) : (this.transformMethod == TransformMethod.SUBTRACT_MA ? new SubtractMATransformer(weights, deviationList) : (this.transformMethod == TransformMethod.NORMALIZE ? new NormalizedTransformer(weights, deviationList) : new NormalizedDifferenceTransformer(weights, deviationList))));
        }
        this.imputationMethod = builder.imputationMethod;
        CommonUtils.checkArgument(builder.fillValues == null || builder.fillValues.length == this.inputLength, " the number of values should match the shingled input");
        if (this.imputationMethod == ImputationMethod.ZERO) {
            this.defaultFill = new double[this.inputLength];
        } else if (this.imputationMethod == ImputationMethod.FIXED_VALUES) {
            CommonUtils.checkArgument(builder.fillValues != null, "fill values cannot be null");
            this.defaultFill = Arrays.copyOf(builder.fillValues, builder.fillValues.length);
        } else {
            this.defaultFill = Preprocessor.copyIfNotnull(builder.fillValues);
        }
        if (this.mode == ForestMode.STREAMING_IMPUTE) {
            this.normalizeTime = true;
            this.useImputedFraction = builder.useImputedFraction.orElse(0.5);
            this.fastForward = builder.fastForward;
        }
    }

    void manageDeviations(Deviation[] deviationList, Optional<Deviation[]> original, double timeDecay) {
        int i;
        CommonUtils.checkArgument(deviationList.length % WeightedTransformer.NUMBER_OF_STATS == 0, " has to be a multiple of five");
        int usedDeviations = 0;
        if (original.isPresent()) {
            Deviation[] list = original.get();
            usedDeviations = Math.min(list.length, deviationList.length);
            for (int i2 = 0; i2 < usedDeviations; ++i2) {
                deviationList[i2] = list[i2].copy();
            }
        }
        for (i = usedDeviations; i < deviationList.length - 2 * deviationList.length / 5; ++i) {
            deviationList[i] = new Deviation(timeDecay);
        }
        for (i = usedDeviations = Math.max(usedDeviations, deviationList.length - 2 * deviationList.length / 5); i < deviationList.length; ++i) {
            deviationList[i] = new Deviation(0.1 * timeDecay);
        }
    }

    public static boolean requireInitialSegment(boolean normalizeTime, TransformMethod transformMethod, ForestMode mode, ImputationMethod imputationMethod) {
        return normalizeTime || imputationMethod != ImputationMethod.ZERO && imputationMethod != ImputationMethod.FIXED_VALUES || transformMethod == TransformMethod.NORMALIZE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE || transformMethod == TransformMethod.SUBTRACT_MA || mode != ForestMode.STANDARD;
    }

    public float[] getScaledInput(double[] point, long timestamp) {
        if (this.valuesSeen < this.startNormalization && Preprocessor.requireInitialSegment(this.normalizeTime, this.transformMethod, this.mode, this.imputationMethod)) {
            return null;
        }
        return this.getScaledInput(point, timestamp, null, this.getTimeShift());
    }

    public float[] getScaledInput(float[] point, long timestamp) {
        return this.getScaledInput(CommonUtils.toDoubleArray(point), timestamp, null, this.getTimeShift());
    }

    @Override
    public float[] getScaledShingledInput(double[] inputPoint, long timestamp, int[] missing, RandomCutForest forest) {
        boolean requireForest = this.imputationMethod == ImputationMethod.RCF || this.mode != ForestMode.STANDARD;
        CommonUtils.checkArgument(!requireForest || forest != null, "need a forest");
        if (!requireForest) {
            float[] scaledInput;
            double[] values;
            double[] newInput = Arrays.copyOf(inputPoint, this.inputLength);
            double[] dArray = values = this.defaultFill != null ? this.defaultFill : this.getShingledInput(this.shingleSize - 1);
            if (missing != null) {
                for (int j : missing) {
                    newInput[j] = values[j];
                }
            }
            if ((scaledInput = this.getScaledInput(newInput, timestamp)) == null) {
                return null;
            }
            float[] point = Arrays.copyOf(this.lastShingledPoint, this.dimension);
            Preprocessor.shiftLeft(point, this.inputLength);
            System.arraycopy(scaledInput, 0, point, this.dimension - this.inputLength, this.inputLength);
            return point;
        }
        float[] scaledInput = this.getScaledInput(inputPoint, timestamp);
        float[] point = null;
        if (scaledInput != null) {
            if (forest.isInternalShinglingEnabled()) {
                point = forest.transformToShingledPoint(scaledInput);
            } else {
                int dimension = forest.getDimensions();
                if (scaledInput.length == dimension) {
                    point = scaledInput;
                } else {
                    point = new float[dimension];
                    System.arraycopy(this.getLastShingledPoint(), scaledInput.length, point, 0, dimension - scaledInput.length);
                    System.arraycopy(scaledInput, 0, point, dimension - scaledInput.length, scaledInput.length);
                }
            }
            if (missing != null) {
                int[] newMissing = Arrays.copyOf(missing, missing.length);
                for (int i = 0; i < missing.length; ++i) {
                    newMissing[i] = missing[i] + this.dimension - scaledInput.length;
                }
                point = forest.imputeMissingValues(point, newMissing.length, newMissing);
            }
        }
        return point;
    }

    @Override
    public double[] getScale() {
        if (this.mode != ForestMode.TIME_AUGMENTED) {
            return this.transformer.getScale();
        }
        double[] scale = new double[this.inputLength + 1];
        System.arraycopy(this.transformer.getScale(), 0, scale, 0, this.inputLength);
        double d = scale[this.inputLength] = this.weightTime == 0.0 ? 0.0 : 1.0 / this.weightTime;
        if (this.normalizeTime) {
            int n = this.inputLength;
            scale[n] = scale[n] * (NORMALIZATION_SCALING_FACTOR * (this.getTimeGapDifference() + DEFAULT_NORMALIZATION_PRECISION));
        }
        return scale;
    }

    @Override
    public boolean isOutputReady() {
        return this.internalTimeStamp > 0;
    }

    @Override
    public double[] getShift() {
        double[] previous;
        double[] dArray = previous = this.inputLength == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        if (this.mode != ForestMode.TIME_AUGMENTED) {
            return this.transformer.getShift(previous);
        }
        double[] shift = new double[this.inputLength + 1];
        System.arraycopy(this.transformer.getShift(previous), 0, shift, 0, this.inputLength);
        shift[this.inputLength] = (this.normalizeTime ? this.getTimeShift() : 0.0) + (double)this.previousTimeStamps[this.shingleSize - 1];
        return shift;
    }

    @Override
    public double[] getSmoothedDeviations() {
        if (this.mode != ForestMode.TIME_AUGMENTED) {
            double[] deviations = new double[2 * this.inputLength];
            System.arraycopy(this.transformer.getSmoothedDeviations(), 0, deviations, 0, this.inputLength);
            System.arraycopy(this.transformer.getSmoothedDifferenceDeviations(), 0, deviations, this.inputLength, this.inputLength);
            return deviations;
        }
        double[] deviations = new double[2 * this.inputLength + 2];
        System.arraycopy(this.transformer.getSmoothedDeviations(), 0, deviations, 0, this.inputLength);
        System.arraycopy(this.transformer.getSmoothedDifferenceDeviations(), 0, deviations, this.inputLength + 1, this.inputLength);
        deviations[this.inputLength + 1] = this.timeStampDeviations[4].getMean();
        deviations[2 * this.inputLength + 1] = this.timeStampDeviations[4].getMean();
        return deviations;
    }

    @Override
    public void update(double[] point, float[] rcfPoint, long timestamp, int[] missing, RandomCutForest forest) {
        this.updateState(point, rcfPoint, timestamp, this.previousTimeStamps[this.shingleSize - 1], missing);
        ++this.valuesSeen;
        double miss = missing == null ? 0.0 : (double)missing.length;
        this.dataQuality[0].update(1.0 - 1.0 * miss / (double)this.inputLength);
        if (forest != null) {
            if (forest.isInternalShinglingEnabled()) {
                int length = this.inputLength + (this.mode == ForestMode.TIME_AUGMENTED ? 1 : 0);
                float[] scaledInput = new float[length];
                System.arraycopy(rcfPoint, rcfPoint.length - length, scaledInput, 0, length);
                forest.update(scaledInput);
            } else {
                forest.update(rcfPoint);
            }
        }
    }

    @Override
    public double dataQuality() {
        return this.dataQuality[0].getMean();
    }

    @Override
    public int numberOfImputes(long timestamp) {
        return 0;
    }

    public long inverseMapTime(double gap, int relativePosition) {
        CommonUtils.checkArgument(this.shingleSize + relativePosition >= 0, " error");
        return this.inverseMapTimeValue(gap, this.previousTimeStamps[this.shingleSize - 1 + relativePosition]);
    }

    protected long inverseMapTimeValue(double gap, long timestamp) {
        double factor;
        double d = factor = this.weightTime == 0.0 ? 0.0 : 1.0 / this.weightTime;
        if (factor == 0.0) {
            return 0L;
        }
        if (this.normalizeTime) {
            return Math.round((double)timestamp + this.getTimeShift() + NORMALIZATION_SCALING_FACTOR * gap * this.getTimeScale() * factor);
        }
        return Math.round(gap * factor + (double)timestamp);
    }

    @Override
    public double[] getShingledInput(int index) {
        int base = this.lastShingledInput.length / this.shingleSize;
        double[] values = new double[base];
        System.arraycopy(this.lastShingledInput, index * base, values, 0, base);
        return values;
    }

    @Override
    public double[] getShingledInput() {
        return Preprocessor.copyIfNotnull(this.lastShingledInput);
    }

    @Override
    public double[] getExpectedValue(int relativeBlockIndex, double[] reference, float[] point, float[] newPoint) {
        CommonUtils.checkArgument(newPoint.length == this.dimension, "incorrect invocation");
        double[] values = CommonUtils.toDoubleArray(this.getExpectedBlock(newPoint, relativeBlockIndex));
        if (reference != null) {
            int startPosition = (this.shingleSize - 1 + relativeBlockIndex) * this.dimension / this.shingleSize;
            int length = this.lastShingledInput.length / this.shingleSize;
            for (int i = 0; i < length; ++i) {
                double currentValue = reference.length == this.dimension ? reference[startPosition + i] : reference[i];
                values[i] = point[startPosition + i] == newPoint[startPosition + i] ? currentValue : values[i];
            }
        }
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            int endPosition = (this.shingleSize - 1 + relativeBlockIndex + 1) * this.dimension / this.shingleSize;
            double timeGap = newPoint[endPosition - 1] - point[endPosition - 1];
            long expectedTimestamp = timeGap == 0.0 ? this.getTimeStamp(this.shingleSize - 1 + relativeBlockIndex) : this.inverseMapTime(timeGap, relativeBlockIndex);
            values[this.dimension / this.shingleSize - 1] = expectedTimestamp;
        }
        return values;
    }

    protected float[] getExpectedBlock(float[] newPoint, int relativeBlockIndex) {
        int startPosition = newPoint.length - (1 - relativeBlockIndex) * this.dimension / this.shingleSize;
        CommonUtils.checkArgument(startPosition >= 0, "incorrect inversion");
        float[] values = new float[this.dimension / this.shingleSize];
        System.arraycopy(newPoint, startPosition, values, 0, this.dimension / this.shingleSize);
        this.invertInPlace(values, this.getShingledInput(this.shingleSize - 1 + relativeBlockIndex), relativeBlockIndex);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            values[this.dimension / this.shingleSize - 1] = this.inverseMapTime(values[this.dimension / this.shingleSize - 1], relativeBlockIndex);
        }
        return values;
    }

    protected void invertInPlace(float[] values, double[] previous, int relativeBlockIndex) {
        CommonUtils.checkArgument(values.length == this.dimension / this.shingleSize, "incorrect invocation");
        this.transformer.invertInPlace(values, previous);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            values[values.length - 1] = this.inverseMapTime(values[values.length - 1], relativeBlockIndex);
        }
    }

    @Override
    public SampleSummary invertInPlaceRecentSummaryBlock(SampleSummary summary) {
        if (summary == null) {
            return null;
        }
        double[] scale = this.getScale();
        double[] previous = this.getShingledInput(this.shingleSize - 1);
        this.invertInPlace(summary.mean, previous, 0);
        this.invertInPlace(summary.median, previous, 0);
        this.invertInPlace(summary.upper, previous, 0);
        this.invertInPlace(summary.lower, previous, 0);
        for (int i = 0; i < summary.summaryPoints.length; ++i) {
            CommonUtils.checkArgument(summary.measure[i].length == scale.length, "only applies to blocks");
            this.invertInPlace(summary.summaryPoints[i], previous, 0);
            for (int j = 0; j < scale.length; ++j) {
                float[] fArray = summary.measure[i];
                int n = j;
                fArray[n] = fArray[n] * (float)scale[j];
            }
        }
        return summary;
    }

    @Override
    public TimedRangeVector invertForecastRange(RangeVector ranges, long lastTimeStamp, double[] delta, boolean useExpected, long expectedTimeStamp) {
        TimedRangeVector timedRangeVector;
        int baseDimension = this.inputLength + (this.mode == ForestMode.TIME_AUGMENTED ? 1 : 0);
        CommonUtils.checkArgument(ranges.values.length % baseDimension == 0, " incorrect length of ranges");
        int horizon = ranges.values.length / baseDimension;
        double[] correction = Preprocessor.copyIfNotnull(delta);
        int gap = (int)((long)this.internalTimeStamp - lastTimeStamp);
        if (correction != null) {
            double decay = Math.max(this.getTransformDecay(), 1.0 / (double)(3 * this.shingleSize));
            double factor = Math.exp((double)(-gap) * decay);
            int i = 0;
            while (i < correction.length) {
                int n = i++;
                correction[n] = correction[n] * factor;
            }
        } else {
            correction = new double[baseDimension];
        }
        long localTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
        if (this.mode != ForestMode.TIME_AUGMENTED) {
            timedRangeVector = new TimedRangeVector(ranges, horizon);
            if (this.mode != ForestMode.STREAMING_IMPUTE) {
                double timeGap = this.getTimeDrift();
                double timeBound = 1.3 * this.getTimeGapDifference();
                for (int i = 0; i < horizon; ++i) {
                    timedRangeVector.timeStamps[i] = this.inverseMapTimeValue(timeGap, localTimeStamp);
                    timedRangeVector.upperTimeStamps[i] = Math.max(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(timeGap + timeBound, localTimeStamp));
                    timedRangeVector.lowerTimeStamps[i] = Math.min(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(0.0, timeGap - timeBound), localTimeStamp));
                    localTimeStamp = timedRangeVector.timeStamps[i];
                }
            }
        } else {
            if (useExpected && gap == 1) {
                localTimeStamp = expectedTimeStamp;
            }
            timedRangeVector = new TimedRangeVector(this.inputLength * horizon, horizon);
            for (int i = 0; i < horizon; ++i) {
                for (int j = 0; j < this.inputLength; ++j) {
                    timedRangeVector.rangeVector.values[i * this.inputLength + j] = ranges.values[i * baseDimension + j];
                    timedRangeVector.rangeVector.upper[i * this.inputLength + j] = ranges.upper[i * baseDimension + j];
                    timedRangeVector.rangeVector.lower[i * this.inputLength + j] = ranges.lower[i * baseDimension + j];
                }
                timedRangeVector.timeStamps[i] = this.inverseMapTimeValue(Math.max(ranges.values[i * baseDimension + this.inputLength], 0.0f), localTimeStamp);
                timedRangeVector.upperTimeStamps[i] = Math.max(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(ranges.upper[i * baseDimension + this.inputLength], 0.0f), localTimeStamp));
                timedRangeVector.lowerTimeStamps[i] = Math.min(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(ranges.lower[i * baseDimension + this.inputLength], 0.0f), localTimeStamp));
                localTimeStamp = timedRangeVector.upperTimeStamps[i];
            }
        }
        this.transformer.invertForecastRange(timedRangeVector.rangeVector, this.inputLength, this.getShingledInput(this.shingleSize - 1), correction);
        return timedRangeVector;
    }

    protected float[] getScaledInput(double[] input, long timestamp, Deviation[] defaults, double defaultTimeFactor) {
        double[] previous = input.length == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        float[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, input, previous, defaults, this.clipFactor);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            scaledInput = this.augmentTime(scaledInput, timestamp, defaultTimeFactor);
        }
        return scaledInput;
    }

    protected void updateShingle(double[] inputPoint, float[] scaledPoint) {
        if (inputPoint.length == this.lastShingledInput.length) {
            this.lastShingledInput = Arrays.copyOf(inputPoint, inputPoint.length);
        } else {
            Preprocessor.shiftLeft(this.lastShingledInput, inputPoint.length);
            Preprocessor.copyAtEnd(this.lastShingledInput, inputPoint);
        }
        if (scaledPoint.length == this.lastShingledPoint.length) {
            this.lastShingledPoint = Arrays.copyOf(scaledPoint, scaledPoint.length);
        } else {
            Preprocessor.shiftLeft(this.lastShingledPoint, scaledPoint.length);
            Preprocessor.copyAtEnd(this.lastShingledPoint, scaledPoint);
        }
    }

    protected void updateTimestamps(long timestamp) {
        for (int i = 0; i < this.shingleSize - 1; ++i) {
            this.previousTimeStamps[i] = this.previousTimeStamps[i + 1];
        }
        this.previousTimeStamps[this.shingleSize - 1] = timestamp;
        ++this.internalTimeStamp;
    }

    protected void updateTimeStampDeviations(long timestamp, long previous) {
        this.timeStampDeviations[0].update(timestamp);
        this.timeStampDeviations[1].update(timestamp - previous);
        this.timeStampDeviations[2].update(this.timeStampDeviations[0].getDeviation());
        this.timeStampDeviations[3].update(this.timeStampDeviations[1].getMean());
        this.timeStampDeviations[4].update(this.timeStampDeviations[1].getDeviation());
    }

    double getTimeScale() {
        return 1.0 + this.getTimeGapDifference();
    }

    double getTimeGapDifference() {
        return Math.abs(this.timeStampDeviations[4].getMean());
    }

    double getTimeShift() {
        return this.timeStampDeviations[1].getMean();
    }

    double getTimeDrift() {
        return this.timeStampDeviations[3].getMean();
    }

    protected void updateState(double[] inputPoint, float[] scaledInput, long timestamp, long previous, int[] missingValues) {
        this.updateTimeStampDeviations(timestamp, previous);
        this.updateTimestamps(timestamp);
        double[] previousInput = this.inputLength == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        this.transformer.updateDeviation(inputPoint, previousInput, missingValues);
        this.updateShingle(inputPoint, scaledInput);
    }

    public static void copyAtEnd(double[] array, double[] small) {
        CommonUtils.checkArgument(array.length >= small.length, " incorrect operation ");
        System.arraycopy(small, 0, array, array.length - small.length, small.length);
    }

    public static void copyAtEnd(float[] array, float[] small) {
        CommonUtils.checkArgument(array.length >= small.length, " incorrect operation ");
        System.arraycopy(small, 0, array, array.length - small.length, small.length);
    }

    protected static double[] copyIfNotnull(double[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    protected static float[] copyIfNotnull(float[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public static void shiftLeft(double[] array, int baseDimension) {
        for (int i = 0; i < array.length - baseDimension; ++i) {
            array[i] = array[i + baseDimension];
        }
    }

    public static void shiftLeft(float[] array, int baseDimension) {
        for (int i = 0; i < array.length - baseDimension; ++i) {
            array[i] = array[i + baseDimension];
        }
    }

    protected double normalize(double value, double factor) {
        double currentFactor;
        double d = currentFactor = factor != 0.0 ? factor : this.getTimeScale();
        if (value - this.getTimeShift() >= NORMALIZATION_SCALING_FACTOR * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return this.clipFactor;
        }
        if (value - this.getTimeShift() <= -NORMALIZATION_SCALING_FACTOR * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return -this.clipFactor;
        }
        return (value - this.getTimeShift()) / (NORMALIZATION_SCALING_FACTOR * (currentFactor + DEFAULT_NORMALIZATION_PRECISION));
    }

    protected float[] augmentTime(float[] normalized, long timestamp, double timeFactor) {
        float[] scaledInput = new float[normalized.length + 1];
        System.arraycopy(normalized, 0, scaledInput, 0, normalized.length);
        if (this.valuesSeen <= 1) {
            scaledInput[normalized.length] = 0.0f;
        } else {
            double timeShift = timestamp - this.previousTimeStamps[this.shingleSize - 1];
            scaledInput[normalized.length] = (float)(this.weightTime * (this.normalizeTime ? this.normalize(timeShift, timeFactor) : timeShift));
        }
        return scaledInput;
    }

    public long[] getInitialTimeStamps() {
        return this.initialTimeStamps == null ? null : Arrays.copyOf(this.initialTimeStamps, this.initialTimeStamps.length);
    }

    public void setInitialTimeStamps(long[] values) {
        this.initialTimeStamps = values == null ? null : Arrays.copyOf(values, values.length);
    }

    public double[][] getInitialValues() {
        if (this.initialValues == null) {
            return null;
        }
        double[][] result = new double[this.initialValues.length][];
        for (int i = 0; i < this.initialValues.length; ++i) {
            result[i] = Preprocessor.copyIfNotnull(this.initialValues[i]);
        }
        return result;
    }

    public void setInitialValues(double[][] values) {
        if (values == null) {
            this.initialValues = null;
        } else {
            this.initialValues = new double[values.length][];
            for (int i = 0; i < values.length; ++i) {
                this.initialValues[i] = Preprocessor.copyIfNotnull(values[i]);
            }
        }
    }

    public double[] getLastShingledInput() {
        return Preprocessor.copyIfNotnull(this.lastShingledInput);
    }

    public void setLastShingledInput(double[] point) {
        this.lastShingledInput = Preprocessor.copyIfNotnull(point);
    }

    public void setPreviousTimeStamps(long[] values) {
        CommonUtils.checkArgument(values.length == this.shingleSize, " incorrect length ");
        this.previousTimeStamps = Arrays.copyOf(values, values.length);
        this.numberOfImputed = 0;
        for (int i = 0; i < this.previousTimeStamps.length - 1; ++i) {
            if (this.previousTimeStamps[i] != this.previousTimeStamps[i + 1]) continue;
            ++this.numberOfImputed;
        }
    }

    public Deviation[] getTimeStampDeviations() {
        return this.timeStampDeviations;
    }

    public long[] getPreviousTimeStamps() {
        return Arrays.copyOf(this.previousTimeStamps, this.previousTimeStamps.length);
    }

    public Deviation[] getDeviationList() {
        return this.transformer.getDeviations();
    }

    @Override
    public double getTransformDecay() {
        return this.transformDecay;
    }

    public double[] getWeights() {
        double[] basic = this.transformer.getWeights();
        double[] answer = new double[this.inputLength + 1];
        System.arraycopy(basic, 0, answer, 0, this.inputLength);
        answer[this.inputLength] = this.weightTime;
        return answer;
    }

    @Override
    public double[] getDefaultFill() {
        return Preprocessor.copyIfNotnull(this.defaultFill);
    }

    @Override
    public void setDefaultFill(double[] values) {
        CommonUtils.checkArgument(values.length == this.inputLength, "incorrect length defaults");
        this.defaultFill = Preprocessor.copyIfNotnull(values);
    }

    @Override
    public long getTimeStamp(int index) {
        return this.previousTimeStamps[index];
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public boolean isNormalizeTime() {
        return this.normalizeTime;
    }

    @Generated
    public double getWeightTime() {
        return this.weightTime;
    }

    @Override
    @Generated
    public int getInternalTimeStamp() {
        return this.internalTimeStamp;
    }

    @Generated
    public int getStartNormalization() {
        return this.startNormalization;
    }

    @Generated
    public Integer getStopNormalization() {
        return this.stopNormalization;
    }

    @Override
    @Generated
    public int getValuesSeen() {
        return this.valuesSeen;
    }

    @Generated
    public double getUseImputedFraction() {
        return this.useImputedFraction;
    }

    @Generated
    public int getNumberOfImputed() {
        return this.numberOfImputed;
    }

    @Override
    @Generated
    public ImputationMethod getImputationMethod() {
        return this.imputationMethod;
    }

    @Generated
    public double getClipFactor() {
        return this.clipFactor;
    }

    @Override
    @Generated
    public float[] getLastShingledPoint() {
        return this.lastShingledPoint;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Override
    @Generated
    public int getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Override
    @Generated
    public int getInputLength() {
        return this.inputLength;
    }

    @Generated
    public ForestMode getMode() {
        return this.mode;
    }

    @Generated
    public Deviation[] getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public ITransformer getTransformer() {
        return this.transformer;
    }

    @Generated
    public boolean isFastForward() {
        return this.fastForward;
    }

    @Generated
    public void setTimeStampDeviations(Deviation[] timeStampDeviations) {
        this.timeStampDeviations = timeStampDeviations;
    }

    @Generated
    public void setNormalizeTime(boolean normalizeTime) {
        this.normalizeTime = normalizeTime;
    }

    @Generated
    public void setWeightTime(double weightTime) {
        this.weightTime = weightTime;
    }

    @Generated
    public void setTransformDecay(double transformDecay) {
        this.transformDecay = transformDecay;
    }

    @Generated
    public void setInternalTimeStamp(int internalTimeStamp) {
        this.internalTimeStamp = internalTimeStamp;
    }

    @Generated
    public void setStartNormalization(int startNormalization) {
        this.startNormalization = startNormalization;
    }

    @Generated
    public void setStopNormalization(Integer stopNormalization) {
        this.stopNormalization = stopNormalization;
    }

    @Generated
    public void setValuesSeen(int valuesSeen) {
        this.valuesSeen = valuesSeen;
    }

    @Generated
    public void setUseImputedFraction(double useImputedFraction) {
        this.useImputedFraction = useImputedFraction;
    }

    @Generated
    public void setNumberOfImputed(int numberOfImputed) {
        this.numberOfImputed = numberOfImputed;
    }

    @Generated
    public void setImputationMethod(ImputationMethod imputationMethod) {
        this.imputationMethod = imputationMethod;
    }

    @Generated
    public void setClipFactor(double clipFactor) {
        this.clipFactor = clipFactor;
    }

    @Generated
    public void setLastShingledPoint(float[] lastShingledPoint) {
        this.lastShingledPoint = lastShingledPoint;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    @Generated
    public void setMode(ForestMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setDataQuality(Deviation[] dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setTransformer(ITransformer transformer) {
        this.transformer = transformer;
    }

    @Generated
    public void setFastForward(boolean fastForward) {
        this.fastForward = fastForward;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int startNormalization = DEFAULT_START_NORMALIZATION;
        protected Integer stopNormalization = DEFAULT_STOP_NORMALIZATION;
        protected double transformDecay;
        protected Optional<Long> randomSeed = Optional.empty();
        protected int shingleSize = 1;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected int inputLength;
        protected boolean normalizeTime = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected double[] initialShingledInput = null;
        protected float[] initialPoint = null;
        protected double weightTime = 1.0;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected Optional<Deviation[]> deviations = Optional.empty();
        protected Optional<Deviation[]> timeDeviations = Optional.empty();
        protected Optional<Deviation[]> dataQuality = Optional.empty();
        protected boolean fastForward = false;

        public Preprocessor build() {
            if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                return new ImputePreprocessor(this);
            }
            if (Preprocessor.requireInitialSegment(this.normalizeTime, this.transformMethod, this.forestMode, this.imputationMethod)) {
                return new InitialSegmentPreprocessor(this);
            }
            return new Preprocessor(this);
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T inputLength(int inputLength) {
            this.inputLength = inputLength;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = startNormalization;
            return (T)this;
        }

        public T stopNormalization(Integer stopNormalization) {
            this.stopNormalization = stopNormalization;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T transformDecay(double transformDecay) {
            this.transformDecay = transformDecay;
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = value;
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T deviations(Deviation[] deviations) {
            this.deviations = Optional.ofNullable(deviations);
            return (T)this;
        }

        public T dataQuality(Deviation[] dataQuality) {
            this.dataQuality = Optional.ofNullable(dataQuality);
            return (T)this;
        }

        public T timeDeviations(Deviation[] timeDeviations) {
            this.timeDeviations = Optional.ofNullable(timeDeviations);
            return (T)this;
        }

        public T initialShingledInput(double[] initialShingledInput) {
            this.initialShingledInput = Preprocessor.copyIfNotnull(initialShingledInput);
            return (T)this;
        }

        public T initialPoint(float[] initialPoint) {
            this.initialPoint = Preprocessor.copyIfNotnull(initialPoint);
            return (T)this;
        }

        public T fastForward(boolean fastForward) {
            this.fastForward = fastForward;
            return (T)this;
        }
    }
}

