/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Instance;

final class InstanceListCopier {
    InstanceListCopier() {
    }

    static List<Instance> copy(Collection<? extends Instance> instanceListParam) {
        Object list;
        if (instanceListParam == null || instanceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(instanceListParam.size());
            instanceListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Instance> copyFromBuilder(Collection<? extends Instance.Builder> instanceListParam) {
        Object list;
        if (instanceListParam == null || instanceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(instanceListParam.size());
            instanceListParam.forEach(entry -> {
                Instance member = entry == null ? null : (Instance)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Instance.Builder> copyToBuilder(Collection<? extends Instance> instanceListParam) {
        Object list;
        if (instanceListParam == null || instanceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(instanceListParam.size());
            instanceListParam.forEach(entry -> {
                Instance.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

