/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnection;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;

public class DescribeClientVpnConnectionsIterable
implements SdkIterable<DescribeClientVpnConnectionsResponse> {
    private final Ec2Client client;
    private final DescribeClientVpnConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientVpnConnectionsIterable(Ec2Client client, DescribeClientVpnConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeClientVpnConnectionsResponseFetcher();
    }

    public Iterator<DescribeClientVpnConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientVpnConnection> connections() {
        Function<DescribeClientVpnConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connections() != null) {
                return response.connections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientVpnConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeClientVpnConnectionsResponse> {
        private DescribeClientVpnConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientVpnConnectionsResponse nextPage(DescribeClientVpnConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnConnectionsIterable.this.client.describeClientVpnConnections(DescribeClientVpnConnectionsIterable.this.firstRequest);
            }
            return DescribeClientVpnConnectionsIterable.this.client.describeClientVpnConnections((DescribeClientVpnConnectionsRequest)((Object)DescribeClientVpnConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

