/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CertificateAuthentication;
import software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType;
import software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication;
import software.amazon.awssdk.services.ec2.model.FederatedAuthentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpnAuthentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpnAuthentication> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ClientVpnAuthentication.getter(ClientVpnAuthentication::typeAsString)).setter(ClientVpnAuthentication.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<DirectoryServiceAuthentication> ACTIVE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveDirectory").getter(ClientVpnAuthentication.getter(ClientVpnAuthentication::activeDirectory)).setter(ClientVpnAuthentication.setter(Builder::activeDirectory)).constructor(DirectoryServiceAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory").unmarshallLocationName("activeDirectory").build()}).build();
    private static final SdkField<CertificateAuthentication> MUTUAL_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MutualAuthentication").getter(ClientVpnAuthentication.getter(ClientVpnAuthentication::mutualAuthentication)).setter(ClientVpnAuthentication.setter(Builder::mutualAuthentication)).constructor(CertificateAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication").unmarshallLocationName("mutualAuthentication").build()}).build();
    private static final SdkField<FederatedAuthentication> FEDERATED_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FederatedAuthentication").getter(ClientVpnAuthentication.getter(ClientVpnAuthentication::federatedAuthentication)).setter(ClientVpnAuthentication.setter(Builder::federatedAuthentication)).constructor(FederatedAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedAuthentication").unmarshallLocationName("federatedAuthentication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD, FEDERATED_AUTHENTICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientVpnAuthentication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final DirectoryServiceAuthentication activeDirectory;
    private final CertificateAuthentication mutualAuthentication;
    private final FederatedAuthentication federatedAuthentication;

    private ClientVpnAuthentication(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
        this.federatedAuthentication = builder.federatedAuthentication;
    }

    public final ClientVpnAuthenticationType type() {
        return ClientVpnAuthenticationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DirectoryServiceAuthentication activeDirectory() {
        return this.activeDirectory;
    }

    public final CertificateAuthentication mutualAuthentication() {
        return this.mutualAuthentication;
    }

    public final FederatedAuthentication federatedAuthentication() {
        return this.federatedAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutualAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.federatedAuthentication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnAuthentication)) {
            return false;
        }
        ClientVpnAuthentication other = (ClientVpnAuthentication)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.activeDirectory(), other.activeDirectory()) && Objects.equals(this.mutualAuthentication(), other.mutualAuthentication()) && Objects.equals(this.federatedAuthentication(), other.federatedAuthentication());
    }

    public final String toString() {
        return ToString.builder((String)"ClientVpnAuthentication").add("Type", (Object)this.typeAsString()).add("ActiveDirectory", (Object)this.activeDirectory()).add("MutualAuthentication", (Object)this.mutualAuthentication()).add("FederatedAuthentication", (Object)this.federatedAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ActiveDirectory": {
                return Optional.ofNullable(clazz.cast(this.activeDirectory()));
            }
            case "MutualAuthentication": {
                return Optional.ofNullable(clazz.cast(this.mutualAuthentication()));
            }
            case "FederatedAuthentication": {
                return Optional.ofNullable(clazz.cast(this.federatedAuthentication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("ActiveDirectory", ACTIVE_DIRECTORY_FIELD);
        map.put("MutualAuthentication", MUTUAL_AUTHENTICATION_FIELD);
        map.put("FederatedAuthentication", FEDERATED_AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnAuthentication, T> g) {
        return obj -> g.apply((ClientVpnAuthentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private DirectoryServiceAuthentication activeDirectory;
        private CertificateAuthentication mutualAuthentication;
        private FederatedAuthentication federatedAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnAuthentication model) {
            this.type(model.type);
            this.activeDirectory(model.activeDirectory);
            this.mutualAuthentication(model.mutualAuthentication);
            this.federatedAuthentication(model.federatedAuthentication);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientVpnAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DirectoryServiceAuthentication.Builder getActiveDirectory() {
            return this.activeDirectory != null ? this.activeDirectory.toBuilder() : null;
        }

        public final void setActiveDirectory(DirectoryServiceAuthentication.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        @Override
        public final Builder activeDirectory(DirectoryServiceAuthentication activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final CertificateAuthentication.Builder getMutualAuthentication() {
            return this.mutualAuthentication != null ? this.mutualAuthentication.toBuilder() : null;
        }

        public final void setMutualAuthentication(CertificateAuthentication.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public final Builder mutualAuthentication(CertificateAuthentication mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final FederatedAuthentication.Builder getFederatedAuthentication() {
            return this.federatedAuthentication != null ? this.federatedAuthentication.toBuilder() : null;
        }

        public final void setFederatedAuthentication(FederatedAuthentication.BuilderImpl federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication != null ? federatedAuthentication.build() : null;
        }

        @Override
        public final Builder federatedAuthentication(FederatedAuthentication federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication;
            return this;
        }

        public ClientVpnAuthentication build() {
            return new ClientVpnAuthentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpnAuthentication> {
        public Builder type(String var1);

        public Builder type(ClientVpnAuthenticationType var1);

        public Builder activeDirectory(DirectoryServiceAuthentication var1);

        default public Builder activeDirectory(Consumer<DirectoryServiceAuthentication.Builder> activeDirectory) {
            return this.activeDirectory((DirectoryServiceAuthentication)((DirectoryServiceAuthentication.Builder)DirectoryServiceAuthentication.builder().applyMutation(activeDirectory)).build());
        }

        public Builder mutualAuthentication(CertificateAuthentication var1);

        default public Builder mutualAuthentication(Consumer<CertificateAuthentication.Builder> mutualAuthentication) {
            return this.mutualAuthentication((CertificateAuthentication)((CertificateAuthentication.Builder)CertificateAuthentication.builder().applyMutation(mutualAuthentication)).build());
        }

        public Builder federatedAuthentication(FederatedAuthentication var1);

        default public Builder federatedAuthentication(Consumer<FederatedAuthentication.Builder> federatedAuthentication) {
            return this.federatedAuthentication((FederatedAuthentication)((FederatedAuthentication.Builder)FederatedAuthentication.builder().applyMutation(federatedAuthentication)).build());
        }
    }
}

