/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import lombok.Generated;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.cache.AbstractLruCache;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCache;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCacheItem;
import org.opensearch.neuralsearch.sparse.cache.LruCacheKey;

public class LruTermCache
extends AbstractLruCache<TermKey> {
    private static final LruTermCache INSTANCE = new LruTermCache();

    protected LruTermCache() {
    }

    public static LruTermCache getInstance() {
        return INSTANCE;
    }

    @Override
    protected long doEviction(TermKey termKey) {
        CacheKey cacheKey = termKey.getCacheKey();
        BytesRef term = termKey.getTerm();
        ClusteredPostingCacheItem clusteredPostingCacheItem = (ClusteredPostingCacheItem)ClusteredPostingCache.getInstance().get(cacheKey);
        if (clusteredPostingCacheItem == null) {
            return 0L;
        }
        return clusteredPostingCacheItem.getWriter().erase(term);
    }

    public static final class TermKey
    implements LruCacheKey {
        private final CacheKey cacheKey;
        private final BytesRef term;

        @Generated
        public TermKey(CacheKey cacheKey, BytesRef term) {
            this.cacheKey = cacheKey;
            this.term = term;
        }

        @Override
        @Generated
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }

        @Generated
        public BytesRef getTerm() {
            return this.term;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TermKey)) {
                return false;
            }
            TermKey other = (TermKey)o;
            CacheKey this$cacheKey = this.getCacheKey();
            CacheKey other$cacheKey = other.getCacheKey();
            if (this$cacheKey == null ? other$cacheKey != null : !((Object)this$cacheKey).equals(other$cacheKey)) {
                return false;
            }
            BytesRef this$term = this.getTerm();
            BytesRef other$term = other.getTerm();
            return !(this$term == null ? other$term != null : !this$term.equals(other$term));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CacheKey $cacheKey = this.getCacheKey();
            result = result * 59 + ($cacheKey == null ? 43 : ((Object)$cacheKey).hashCode());
            BytesRef $term = this.getTerm();
            result = result * 59 + ($term == null ? 43 : $term.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LruTermCache.TermKey(cacheKey=" + String.valueOf(this.getCacheKey()) + ", term=" + String.valueOf(this.getTerm()) + ")";
        }
    }
}

