/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdMaxRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdRowCount
implements MetadataHandler<BuiltInMetadata.RowCount> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdRowCount(), BuiltInMetadata.RowCount.Handler.class);

    @Override
    public MetadataDef<BuiltInMetadata.RowCount> getDef() {
        return BuiltInMetadata.RowCount.DEF;
    }

    public @Nullable Double getRowCount(RelNode rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public @Nullable Double getRowCount(RelSubset subset, RelMetadataQuery mq) {
        return mq.getRowCount(subset.stripped());
    }

    public @Nullable Double getRowCount(Union rel, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            rowCount += partialRowCount.doubleValue();
        }
        if (!rel.all) {
            rowCount *= 0.5;
        }
        return rowCount;
    }

    public @Nullable Double getRowCount(Intersect rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        if (rowCount == null || !rel.all) {
            return rowCount;
        }
        return rowCount * 2.0;
    }

    public @Nullable Double getRowCount(Minus rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getRowCount(Filter rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getCondition(), mq);
    }

    public Double getRowCount(Calc rel, RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(rel.getInput(), rel.getProgram(), mq);
    }

    public @Nullable Double getRowCount(Project rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public @Nullable Double getRowCount(Sort rel, RelMetadataQuery mq) {
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        int offset = rel.offset instanceof RexLiteral ? RexLiteral.intValue(rel.offset) : 0;
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        double limit = rel.fetch instanceof RexLiteral ? (double)RexLiteral.intValue(rel.fetch) : rowCount;
        return limit < rowCount ? limit : rowCount;
    }

    public @Nullable Double getRowCount(EnumerableLimit rel, RelMetadataQuery mq) {
        Double rowCount = mq.getRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        int offset = rel.offset instanceof RexLiteral ? RexLiteral.intValue(rel.offset) : 0;
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        double limit = rel.fetch instanceof RexLiteral ? (double)RexLiteral.intValue(rel.fetch) : rowCount;
        return limit < rowCount ? limit : rowCount;
    }

    public @Nullable Double getRowCount(Sample rel, RelMetadataQuery mq) {
        Double inputRowCount = mq.getRowCount(rel.getInput());
        double sampleRate = rel.getSamplingParameters().sampleRate.doubleValue();
        return sampleRate * inputRowCount;
    }

    public @Nullable Double getRowCount(SingleRel rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public @Nullable Double getRowCount(Join rel, RelMetadataQuery mq) {
        return RelMdUtil.getJoinRowCount(mq, rel, rel.getCondition());
    }

    public Double getRowCount(Aggregate rel, RelMetadataQuery mq) {
        RelOptPredicateList predicateList;
        ImmutableBitSet groupKey = rel.getGroupSet();
        if (groupKey.isEmpty()) {
            return 1.0;
        }
        if (rel.getGroupType() == Aggregate.Group.SIMPLE && !RelOptPredicateList.isEmpty(predicateList = mq.getPulledUpPredicates(rel.getInput())) && RelMdMaxRowCount.allGroupKeysAreConstant(rel, predicateList)) {
            return 1.0;
        }
        Double distinctRowCount = mq.getDistinctRowCount(rel.getInput(), groupKey, null);
        if (distinctRowCount == null) {
            distinctRowCount = mq.getRowCount(rel.getInput()) / 10.0;
        }
        distinctRowCount = distinctRowCount * (double)rel.getGroupSets().size();
        return distinctRowCount;
    }

    public @Nullable Double getRowCount(TableScan rel, RelMetadataQuery mq) {
        BuiltInMetadata.RowCount.Handler handler = rel.getTable().unwrap(BuiltInMetadata.RowCount.Handler.class);
        if (handler != null) {
            return handler.getRowCount(rel, mq);
        }
        return rel.estimateRowCount(mq);
    }

    public Double getRowCount(Values rel, RelMetadataQuery mq) {
        return rel.estimateRowCount(mq);
    }

    public @Nullable Double getRowCount(Exchange rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }

    public @Nullable Double getRowCount(TableModify rel, RelMetadataQuery mq) {
        return mq.getRowCount(rel.getInput());
    }
}

