/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

class SchemaNamespace
extends AbstractNamespace {
    private final ImmutableList<String> names;

    SchemaNamespace(SqlValidatorImpl validator, List<String> names) {
        super(validator, null);
        this.names = ImmutableList.copyOf(names);
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (SqlMoniker moniker : this.validator.catalogReader.getAllSchemaObjectNames(this.names)) {
            List<String> names1 = moniker.getFullyQualifiedNames();
            SqlValidatorTable table = Objects.requireNonNull(this.validator.catalogReader.getTable(names1), () -> "table " + names1 + " is not found in scope " + this.names);
            ((RelDataTypeFactory.Builder)builder).add(Util.last(names1), table.getRowType());
        }
        return builder.build();
    }

    @Override
    public @Nullable SqlNode getNode() {
        return null;
    }
}

