/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.calcite.CalcitePlanContext;

public interface JoinAndLookupUtils {
    public static JoinRelType translateJoinType(Join.JoinType joinType) {
        switch (joinType) {
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
            case SEMI: {
                return JoinRelType.SEMI;
            }
            case ANTI: {
                return JoinRelType.ANTI;
            }
        }
        return JoinRelType.INNER;
    }

    public static Map<String, String> findDuplicatedFields(Lookup node, List<String> sourceFieldsNames, List<String> providedFieldNames) {
        return providedFieldNames.stream().map(k -> Pair.of(node.getOutputAliasMap().getOrDefault(k, (String)k), k)).filter(pair -> sourceFieldsNames.contains(pair.getKey())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static void addProjectionIfNecessary(Lookup node, CalcitePlanContext context) {
        List mappingField = node.getMappingAliasMap().keySet().stream().toList();
        List outputField = node.getOutputAliasMap().keySet().stream().toList();
        if (!outputField.isEmpty()) {
            HashSet lookupMappingFields = new HashSet(outputField);
            lookupMappingFields.addAll(mappingField);
            if (lookupMappingFields.size() != context.relBuilder.fields().size()) {
                List<RexNode> projectList = lookupMappingFields.stream().map(fieldName -> context.relBuilder.field((String)fieldName)).toList();
                context.relBuilder.project(projectList);
            }
        }
    }

    public static void addJoinForLookUp(Lookup node, CalcitePlanContext context) {
        RexNode joinCondition = node.getMappingAliasMap().entrySet().stream().map(entry -> {
            RexNode lookupKey = JoinAndLookupUtils.analyzeFieldsForLookUp((String)entry.getKey(), false, context);
            RexNode sourceKey = JoinAndLookupUtils.analyzeFieldsForLookUp((String)entry.getValue(), true, context);
            return context.rexBuilder.equals(sourceKey, lookupKey);
        }).reduce(context.rexBuilder::and).orElse(context.relBuilder.literal(true));
        context.relBuilder.join(JoinRelType.LEFT, joinCondition);
    }

    public static RexNode analyzeFieldsForLookUp(String fieldName, boolean isSourceTable, CalcitePlanContext context) {
        return context.relBuilder.field(2, isSourceTable ? 0 : 1, fieldName);
    }

    public static void renameToExpectedFields(List<String> expectedProvidedFieldNames, int sourceFieldsCountLeft, CalcitePlanContext context) {
        List<String> oldFields = context.relBuilder.peek().getRowType().getFieldNames();
        if (!2.$assertionsDisabled && sourceFieldsCountLeft + expectedProvidedFieldNames.size() != oldFields.size()) {
            throw new AssertionError((Object)"The source fields count left plus new provided fields count must equal to the output fields count of current plan(i.e project-join).");
        }
        ArrayList<String> newFields = new ArrayList<String>(oldFields.size());
        newFields.addAll(oldFields.subList(0, sourceFieldsCountLeft));
        newFields.addAll(expectedProvidedFieldNames);
        context.relBuilder.rename(newFields);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

