/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;
import net.sourceforge.plantuml.utils.Position;

public abstract class PanelsState
extends Panels {
    private static final int DEFAULT_RIBBON_HEIGHT = 24;
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private String initialState;
    private Colors initialColors;

    protected PanelsState(TimingRuler ruler, ISkinParam skinParam, int suggestedHeight, Style style, List<TimingNote> notes, List<TimeConstraint> constraints) {
        super(ruler, skinParam, suggestedHeight == 0 ? 24 : suggestedHeight, style, notes, constraints);
    }

    @Override
    public final IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        if (tick == null) {
            return null;
        }
        double x = this.ruler.getPosInPixel(tick);
        double y = this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + this.getHeightForTopComment(stringBounder) + this.getRibbonHeight() / 2.0;
        for (ChangeState change : this.changes) {
            if (change.getWhen().compareTo(tick) != 0) continue;
            return new IntricatedPoint(new XPoint2D(x, y), new XPoint2D(x, y));
        }
        return new IntricatedPoint(new XPoint2D(x, y - this.getRibbonHeight() / 2.0), new XPoint2D(x, y + this.getRibbonHeight() / 2.0));
    }

    public final void addChange(ChangeState change) {
        this.changes.add(change);
    }

    protected final double getPosInPixel(ChangeState change) {
        return this.ruler.getPosInPixel(change.getWhen());
    }

    @Override
    public final void drawLeftPanel(UGraphic ug, double fullAvailableWidth) {
    }

    @Override
    public final double getLeftPanelWidth(StringBounder stringBounder) {
        return this.getInitialWidth(stringBounder);
    }

    @Override
    public final void drawRightPanel(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UGraphic ugRibbon = ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) + this.getHeightForTopComment(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP)));
        this.drawBeforeZeroState(ugRibbon);
        this.drawBeforeZeroStateLabel(ugRibbon.apply(UTranslate.dy(this.getRibbonHeight() / 2.0)));
        this.drawStates(ugRibbon);
        this.drawStatesLabels(ugRibbon.apply(UTranslate.dy(this.getRibbonHeight() / 2.0)));
        this.drawConstraints(ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) / 2.0)));
        this.drawNotes(ug, Position.TOP);
        this.drawNotes(ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) + this.getRibbonHeight() + this.getHeightForNotes(stringBounder, Position.TOP))), Position.BOTTOM);
    }

    private double getInitialWidth(StringBounder stringBounder) {
        if (this.initialState == null) {
            return 0.0;
        }
        return this.createTextBlock(this.initialState).calculateDimension(stringBounder).getWidth() + 24.0;
    }

    protected abstract void drawHexa(UGraphic var1, double var2, ChangeState var4);

    protected abstract void drawPentaA(UGraphic var1, double var2, ChangeState var4);

    protected abstract void drawPentaB(UGraphic var1, double var2, ChangeState var4);

    protected final void drawFlat(UGraphic ug, double len, ChangeState change) {
        ULine line = ULine.hline(len);
        change.getContext(this.skinParam, this.style).apply(ug).apply(UTranslate.dy(this.getRibbonHeight() / 2.0)).draw(line);
    }

    protected final double getRibbonHeight() {
        return this.suggestedHeight;
    }

    public final void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        this.initialColors = initialColors;
    }

    protected final String getInitialState() {
        return this.initialState;
    }

    protected final Colors getInitialColors() {
        return this.initialColors;
    }

    protected final List<ChangeState> getChanges() {
        return this.changes;
    }

    private void drawBeforeZeroState(UGraphic ug) {
        if (this.initialState == null) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        if (this.changes.size() == 0) {
            this.drawSingle(ug.apply(UTranslate.dx(-this.getInitialWidth(stringBounder))), this.getInitialWidth(stringBounder) + this.ruler.getWidth());
        } else {
            double a = this.getPosInPixel(this.changes.get(0));
            if (ChangeState.isFlat(this.initialState)) {
                this.drawFlat(ug.apply(UTranslate.dx(-this.getInitialWidth(stringBounder))), this.getInitialWidth(stringBounder) + a, this.changes.get(0));
            } else {
                this.drawPentaA(ug.apply(UTranslate.dx(-this.getInitialWidth(stringBounder))), this.getInitialWidth(stringBounder) + a, this.changes.get(0));
            }
        }
    }

    private void drawBeforeZeroStateLabel(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        if (this.initialState != null && !ChangeState.isFlat(this.initialState)) {
            TextBlock initial = this.createTextBlock(this.initialState);
            XDimension2D dimInital = initial.calculateDimension(stringBounder);
            initial.drawU(ug.apply(new UTranslate(-12.0 - dimInital.getWidth(), -dimInital.getHeight() / 2.0)));
        }
    }

    private void drawSingle(UGraphic ug, double len) {
        HColor back = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor line = this.style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        Fashion context = new Fashion(back, back).withStroke(this.style.getStroke());
        ug = context.apply(ug);
        ULine border = ULine.hline(len);
        double height = this.getRibbonHeight();
        if (ChangeState.isFlat(this.initialState)) {
            ug = ug.apply(line);
            ug.apply(UTranslate.dy(height / 2.0)).draw(border);
            return;
        }
        URectangle rect = URectangle.build(len, height);
        ug.draw(rect);
        ug = ug.apply(line);
        ug.draw(border);
        ug.apply(UTranslate.dy(height)).draw(border);
    }

    private void drawStates(UGraphic ug) {
        double a;
        for (int i = 0; i < this.changes.size() - 1; ++i) {
            a = this.getPosInPixel(this.changes.get(i));
            double b = this.getPosInPixel(this.changes.get(i + 1));
            assert (b > a);
            if (this.changes.get(i).isFlat()) {
                this.drawFlat(ug.apply(UTranslate.dx(a)), b - a, this.changes.get(i));
                continue;
            }
            if (this.changes.get(i).isCompletelyHidden()) continue;
            this.drawHexa(ug.apply(UTranslate.dx(a)), b - a, this.changes.get(i));
        }
        if (this.changes.size() >= 1) {
            ChangeState last = this.changes.get(this.changes.size() - 1);
            a = this.getPosInPixel(last);
            if (last.isFlat()) {
                this.drawFlat(ug.apply(UTranslate.dx(a)), this.ruler.getWidth() - a, last);
            } else if (!last.isCompletelyHidden()) {
                this.drawPentaB(ug.apply(UTranslate.dx(a)), this.ruler.getWidth() - a, last);
            }
        }
    }

    private void drawStatesLabels(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (int i = 0; i < this.changes.size(); ++i) {
            ChangeState change = this.changes.get(i);
            double x = this.ruler.getPosInPixel(change.getWhen());
            if (!(change.isBlank() || change.isCompletelyHidden() || change.isFlat())) {
                double xtext;
                TextBlock state = this.createTextBlock(change.getState());
                XDimension2D dim = state.calculateDimension(stringBounder);
                if (i == this.changes.size() - 1) {
                    xtext = x + 12.0;
                } else {
                    double x2 = this.ruler.getPosInPixel(this.changes.get(i + 1).getWhen());
                    xtext = (x + x2) / 2.0 - dim.getWidth() / 2.0;
                }
                state.drawU(ug.apply(new UTranslate(xtext, -dim.getHeight() / 2.0)));
            }
            TextBlock commentTopBlock = this.getCommentTopBlock(change);
            XDimension2D dimComment = commentTopBlock.calculateDimension(stringBounder);
            commentTopBlock.drawU(ug.apply(new UTranslate(x + 12.0, -this.getRibbonHeight() / 2.0 - dimComment.getHeight())));
        }
    }

    private TextBlock getCommentTopBlock(ChangeState change) {
        if (change.getComment() == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return this.createTextBlock(change.getComment());
    }

    protected double getHeightForTopComment(StringBounder stringBounder) {
        double result = 0.0;
        for (ChangeState change : this.changes) {
            result = Math.max(result, this.getCommentTopBlock(change).calculateDimension(stringBounder).getHeight());
        }
        return result;
    }

    protected final Fashion getContextWithInitialColors(ChangeState change) {
        Fashion context = change.getContext(this.skinParam, this.style);
        HColor back = this.initialColors.getColor(ColorType.BACK);
        HColor line = this.initialColors.getColor(ColorType.LINE);
        if (back != null) {
            context = context.withBackColor(back);
        }
        if (line != null) {
            context = context.withForeColor(line);
        }
        return context;
    }

    @Override
    protected final double getHeightForConstraints(StringBounder stringBounder) {
        return Math.max(5.0, super.getHeightForConstraints(stringBounder));
    }

    @Override
    public final double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForTopComment(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + this.getRibbonHeight() + this.getHeightForNotes(stringBounder, Position.BOTTOM) + 10.0;
    }
}

