\name{SpeckleNoiseImageFilter}
\alias{SpeckleNoiseImageFilter}
\title{SpeckleNoiseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Alter an image with speckle (multiplicative) noise.
SpeckleNoiseImageFilter}
\details{
The speckle noise follows a gamma distribution of mean 1 and standard
deviation provided by the user. The noise is proportional to the pixel
intensity.
It can be modeled as:
 \eqn{ I = I_0 \ast G }
where \eqn{ G } is a is a gamma distributed random variable of mean 1 and variance
proportional to the noise level:
 \eqn{ G \sim \Gamma(\frac{1}{\sigma^2}, \sigma^2) }
Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://www.insight-journal.org/browse/publication/721
See:
SpeckleNoise for the procedural interface
itk::SpeckleNoiseImageFilter for the Doxygen on the original ITK class.
SpeckleNoiseImageFilter}
%C++ includes: sitkSpeckleNoiseImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetSeed() const:}{}
\item{double GetStandardDeviation() const:}{
Set/Get the standard deviation of the gamma distribution. Defaults to
1.0.
}
\item{Self SetSeed(uint32_t Seed):}{}
\item{Self SetStandardDeviation(double StandardDeviation):}{
Set/Get the standard deviation of the gamma distribution. Defaults to
1.0.
}
\item{ SpeckleNoiseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SpeckleNoiseImageFilter():}{
Destructor
}
}
}
