\name{DisplacementFieldJacobianDeterminantFilter}
\alias{DisplacementFieldJacobianDeterminantFilter}
\title{DisplacementFieldJacobianDeterminantFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes a scalar image from a vector image (e.g., deformation field)
input, where each output scalar at each pixel is the Jacobian
determinant of the vector field at that location. This calculation is
correct in the case where the vector image is a "displacement" from
the current location. The computation for the jacobian determinant is:
det[ dT/dx ] = det[ I + du/dx ].
DisplacementFieldJacobianDeterminantFilter}
\details{
Overview
This filter is based on itkVectorGradientMagnitudeImageFilter and
supports the m_DerivativeWeights weights for partial derivatives.
 Note that the determinant of a zero vector field is also zero,
whereas the Jacobian determinant of the corresponding identity warp
transformation is 1.0. In order to compute the effective deformation
Jacobian determinant 1.0 must be added to the diagonal elements of
Jacobian prior to taking the derivative. i.e. det([ (1.0+dx/dx) dx/dy
dx/dz ; dy/dx (1.0+dy/dy) dy/dz; dz/dx dz/dy (1.0+dz/dz) ])
Template Parameters (Input and Output)
This filter has one required template parameter which defines the
input image type. The pixel type of the input image is assumed to be a
vector (e.g., itk::Vector , itk::RGBPixel , itk::FixedArray ). The scalar type of the vector components must be castable to
floating point. Instantiating with an image of RGBPixel<unsigned
short>, for example, is allowed, but the filter will convert it to an
image of Vector<float,3> for processing.
 The second template parameter, TRealType, can be optionally specified
to define the scalar numerical type used in calculations. This is the
component type of the output image, which will be of
itk::Vector<TRealType, N>, where N is the number of channels in the
multiple component input image. The default type of TRealType is
float. For extra precision, you may safely change this parameter to
double.
The third template parameter is the output image type. The third
parameter will be automatically constructed from the first and second
parameters, so it is not necessary (or advisable) to set this
parameter explicitly. Given an M-channel input image with
dimensionality N, and a numerical type specified as TRealType, the
output image will be of type itk::Image<TRealType, N>.
Filter Parameters
The method UseImageSpacingOn will cause derivatives in the image to be
scaled (inversely) with the pixel size of the input image, effectively
taking derivatives in world coordinates (versus isotropic image
space). UseImageSpacingOff turns this functionality off. Default is
UseImageSpacingOn. The parameter UseImageSpacing can be set directly
with the method SetUseImageSpacing(bool) .
 Weights can be applied to the derivatives directly using the
SetDerivativeWeights method. Note that if UseImageSpacing is set to
TRUE (ON), then these weights will be overridden by weights derived
from the image spacing when the filter is updated. The argument to
this method is a C array of TRealValue type.
Constraints
We use vnl_det for determinant computation, which only supports square
matrices. So the vector dimension of the input image values must be
equal to the image dimensions, which is trivially true for a
deformation field that maps an n-dimensional space onto itself.
 Currently, dimensions up to and including 4 are supported. This
limitation comes from the presence of vnl_det() functions for matrices
of dimension up to 4x4.
The template parameter TRealType must be floating point (float or
double) or a user-defined "real" numerical type with arithmetic
operations defined sufficient to compute derivatives.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
This class was adapted by
Hans J. Johnson, The University of Iowa from code provided by
Tom Vercauteren, INRIA & Mauna Kea Technologies
Torsten Rohlfing, Neuroscience Program, SRI International.
See:
DisplacementFieldJacobianDeterminantFilter for the procedural interface
itk::DisplacementFieldJacobianDeterminantFilter for the Doxygen on the original ITK class.
DisplacementFieldJacobianDeterminantFilter}
%C++ includes: sitkDisplacementFieldJacobianDeterminantFilter.h
\section{Methods}{
\describe{
\item{ DisplacementFieldJacobianDeterminantFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< double > GetDerivativeWeights() const:}{
Directly Set/Get the array of weights used in the gradient
calculations. Note that calling UseImageSpacingOn will clobber these
values.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image (1/spacing) in the calculation of the Jacobian determinant. Use
On to compute the Jacobian determinant in the space in which the data
was acquired; use Off to reset the derivative weights, ignore the
image spacing, and to compute the Jacobian determinant in the image
space. Default is On.
}
\item{Self SetDerivativeWeights(std::vector< double > DerivativeWeights):}{
Directly Set/Get the array of weights used in the gradient
calculations. Note that calling UseImageSpacingOn will clobber these
values.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image (1/spacing) in the calculation of the Jacobian determinant. Use
On to compute the Jacobian determinant in the space in which the data
was acquired; use Off to reset the derivative weights, ignore the
image spacing, and to compute the Jacobian determinant in the image
space. Default is On.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~DisplacementFieldJacobianDeterminantFilter():}{
Destructor
}
}
}
