/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.auth.oauth2;

import java.io.File;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.DefaultCredentialsProvider;

public class GoogleAuthUtils {
    public static final String getWellKnownCredentialsPath() {
        return GoogleAuthUtils.getWellKnownCredentialsFile(DefaultCredentialsProvider.DEFAULT).getAbsolutePath();
    }

    static final String getWellKnownCredentialsPath(DefaultCredentialsProvider provider) {
        return GoogleAuthUtils.getWellKnownCredentialsFile(provider).getAbsolutePath();
    }

    static final File getWellKnownCredentialsFile(DefaultCredentialsProvider provider) {
        File cloudConfigPath;
        String envPath = provider.getEnv("CLOUDSDK_CONFIG");
        if (envPath != null) {
            cloudConfigPath = new File(envPath);
        } else if (provider.getOsName().indexOf("windows") >= 0) {
            File appDataPath = new File(provider.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, "gcloud");
        } else {
            File configPath = new File(provider.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, "gcloud");
        }
        return new File(cloudConfigPath, "application_default_credentials.json");
    }
}

