/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.util.DecorrelatedJitterBackoff;

@SnowflakeJdbcInternalApi
public class HttpExecutingContext {
    private static final long minBackoffMillis = 1000L;
    private static final long maxBackoffMillis = 16000L;
    private static final int MIN_RETRY_COUNT = 1;
    private static final int DEFAULT_RETRY_TIMEOUT = 300;
    private final String requestId;
    private final String requestInfoScrubbed;
    private final long startTime;
    private long startTimePerRequest;
    private boolean isLoginRequest;
    private long elapsedMilliForTransientIssues;
    private long retryTimeout;
    private long authTimeout;
    private DecorrelatedJitterBackoff backoff;
    private long backoffInMillis;
    private int origSocketTimeout;
    private String breakRetryReason;
    private String breakRetryEventName;
    private String lastStatusCodeForRetry;
    private int retryCount;
    private int maxRetries;
    private boolean noRetry;
    private int injectSocketTimeout;
    private boolean retryHTTP403;
    private boolean shouldRetry;
    private boolean skipRetriesBecauseOf200;
    private boolean withoutCookies;
    private boolean includeRetryParameters;
    private boolean includeSnowflakeHeaders;
    private boolean unpackResponse;
    private AtomicBoolean canceling;
    private SFBaseSession sfSession;

    public HttpExecutingContext(String requestIdStr, String requestInfoScrubbed) {
        this.requestId = requestIdStr;
        this.requestInfoScrubbed = requestInfoScrubbed;
        this.startTimePerRequest = this.startTime = System.currentTimeMillis();
        this.backoff = new DecorrelatedJitterBackoff(this.getMinBackoffInMillis(), this.getMaxBackoffInMilli());
        this.backoffInMillis = 1000L;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimePerRequest() {
        return this.startTimePerRequest;
    }

    public void setStartTimePerRequest(long startTimePerRequest) {
        this.startTimePerRequest = startTimePerRequest;
    }

    public boolean isLoginRequest() {
        return this.isLoginRequest;
    }

    public void setLoginRequest(boolean loginRequest) {
        this.isLoginRequest = loginRequest;
    }

    public long getElapsedMilliForTransientIssues() {
        return this.elapsedMilliForTransientIssues;
    }

    public long getRetryTimeoutInMilliseconds() {
        return this.retryTimeout * 1000L;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public long getMinBackoffInMillis() {
        return 1000L;
    }

    public long getBackoffInMillis() {
        return this.backoffInMillis;
    }

    public void setBackoffInMillis(long backoffInMillis) {
        this.backoffInMillis = backoffInMillis;
    }

    public long getMaxBackoffInMilli() {
        return 16000L;
    }

    public long getAuthTimeout() {
        return this.authTimeout;
    }

    public long getAuthTimeoutInMilliseconds() {
        return this.authTimeout * 1000L;
    }

    public void setAuthTimeout(long authTimeout) {
        this.authTimeout = authTimeout;
    }

    public DecorrelatedJitterBackoff getBackoff() {
        return this.backoff;
    }

    public void setBackoff(DecorrelatedJitterBackoff backoff) {
        this.backoff = backoff;
    }

    public int getOrigSocketTimeout() {
        return this.origSocketTimeout;
    }

    public void setOrigSocketTimeout(int origSocketTimeout) {
        this.origSocketTimeout = origSocketTimeout;
    }

    public String getBreakRetryReason() {
        return this.breakRetryReason;
    }

    public void setBreakRetryReason(String breakRetryReason) {
        this.breakRetryReason = breakRetryReason;
    }

    public String getBreakRetryEventName() {
        return this.breakRetryEventName;
    }

    public void setBreakRetryEventName(String breakRetryEventName) {
        this.breakRetryEventName = breakRetryEventName;
    }

    public String getLastStatusCodeForRetry() {
        return this.lastStatusCodeForRetry;
    }

    public void setLastStatusCodeForRetry(String lastStatusCodeForRetry) {
        this.lastStatusCodeForRetry = lastStatusCodeForRetry;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void resetRetryCount() {
        this.retryCount = 0;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public String getRequestInfoScrubbed() {
        return this.requestInfoScrubbed;
    }

    public boolean isNoRetry() {
        return this.noRetry;
    }

    public void setNoRetry(boolean noRetry) {
        this.noRetry = noRetry;
    }

    public boolean isRetryHTTP403() {
        return this.retryHTTP403;
    }

    public void setRetryHTTP403(boolean retryHTTP403) {
        this.retryHTTP403 = retryHTTP403;
    }

    public boolean isShouldRetry() {
        return this.shouldRetry;
    }

    public void setShouldRetry(boolean shouldRetry) {
        this.shouldRetry = shouldRetry;
    }

    public void increaseElapsedMilliForTransientIssues(long elapsedMilliForLastCall) {
        this.elapsedMilliForTransientIssues += elapsedMilliForLastCall;
    }

    public boolean elapsedTimeExceeded() {
        return this.elapsedMilliForTransientIssues > this.getRetryTimeoutInMilliseconds();
    }

    public boolean moreThanMinRetries() {
        return this.retryCount >= 1;
    }

    public boolean maxRetriesExceeded() {
        return this.maxRetries > 0 && this.retryCount >= this.maxRetries;
    }

    public boolean socketOrConnectTimeoutReached() {
        return this.authTimeout > 0L && this.elapsedMilliForTransientIssues > this.getAuthTimeoutInMilliseconds() && (this.origSocketTimeout == 0 || this.elapsedMilliForTransientIssues < (long)this.origSocketTimeout);
    }

    public AtomicBoolean getCanceling() {
        return this.canceling;
    }

    public void setCanceling(AtomicBoolean canceling) {
        this.canceling = canceling;
    }

    public boolean isIncludeSnowflakeHeaders() {
        return this.includeSnowflakeHeaders;
    }

    public void setIncludeSnowflakeHeaders(boolean includeSnowflakeHeaders) {
        this.includeSnowflakeHeaders = includeSnowflakeHeaders;
    }

    public boolean isWithoutCookies() {
        return this.withoutCookies;
    }

    public void setWithoutCookies(boolean withoutCookies) {
        this.withoutCookies = withoutCookies;
    }

    public int isInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public boolean isIncludeRetryParameters() {
        return this.includeRetryParameters;
    }

    public boolean isUnpackResponse() {
        return this.unpackResponse;
    }

    public void setUnpackResponse(boolean unpackResponse) {
        this.unpackResponse = unpackResponse;
    }

    public void setIncludeRetryParameters(boolean includeRetryParameters) {
        this.includeRetryParameters = includeRetryParameters;
    }

    public boolean isSkipRetriesBecauseOf200() {
        return this.skipRetriesBecauseOf200;
    }

    public void setSkipRetriesBecauseOf200(boolean skipRetriesBecauseOf200) {
        this.skipRetriesBecauseOf200 = skipRetriesBecauseOf200;
    }

    public SFBaseSession getSfSession() {
        return this.sfSession;
    }

    public void setSfSession(SFBaseSession sfSession) {
        this.sfSession = sfSession;
    }
}

