/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.CorsProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.CorsRule;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.LoggingOperations;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.LoggingProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.MetricsLevel;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.MetricsProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.ServiceProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

final class ServicePropertiesSerializer {
    ServicePropertiesSerializer() {
    }

    public static byte[] serializeToByteArray(ServiceProperties properties) throws XMLStreamException, StorageException {
        StringWriter outWriter = new StringWriter();
        XMLStreamWriter xmlw = Utility.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("StorageServiceProperties");
        if (properties.getLogging() != null) {
            ServicePropertiesSerializer.writeLoggingProperties(xmlw, properties.getLogging());
        }
        if (properties.getHourMetrics() != null) {
            ServicePropertiesSerializer.writeMetricsProperties(xmlw, properties.getHourMetrics(), "HourMetrics");
        }
        if (properties.getMinuteMetrics() != null) {
            ServicePropertiesSerializer.writeMetricsProperties(xmlw, properties.getMinuteMetrics(), "MinuteMetrics");
        }
        if (properties.getCors() != null) {
            ServicePropertiesSerializer.writeCorsProperties(xmlw, properties.getCors());
        }
        if (properties.getDefaultServiceVersion() != null) {
            xmlw.writeStartElement("DefaultServiceVersion");
            xmlw.writeCharacters(properties.getDefaultServiceVersion());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    private static void writeRetentionPolicy(XMLStreamWriter xmlw, Integer val) throws XMLStreamException {
        xmlw.writeStartElement("RetentionPolicy");
        xmlw.writeStartElement("Enabled");
        xmlw.writeCharacters(val != null ? "true" : "false");
        xmlw.writeEndElement();
        if (val != null) {
            xmlw.writeStartElement("Days");
            xmlw.writeCharacters(val.toString());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
    }

    private static void writeCorsProperties(XMLStreamWriter xmlw, CorsProperties cors) throws XMLStreamException {
        Utility.assertNotNull("CorsRules", cors.getCorsRules());
        xmlw.writeStartElement("Cors");
        for (CorsRule rule : cors.getCorsRules()) {
            if (rule.getAllowedOrigins().isEmpty() || rule.getAllowedMethods().isEmpty() || rule.getMaxAgeInSeconds() < 0) {
                throw new IllegalArgumentException("A CORS rule must contain at least one allowed origin and allowed method, and MaxAgeInSeconds cannot have a value less than zero.");
            }
            xmlw.writeStartElement("CorsRule");
            xmlw.writeStartElement("AllowedOrigins");
            xmlw.writeCharacters(ServicePropertiesSerializer.joinToString(rule.getAllowedOrigins(), ","));
            xmlw.writeEndElement();
            xmlw.writeStartElement("AllowedMethods");
            xmlw.writeCharacters(ServicePropertiesSerializer.joinToString(rule.getAllowedMethods(), ","));
            xmlw.writeEndElement();
            xmlw.writeStartElement("ExposedHeaders");
            xmlw.writeCharacters(ServicePropertiesSerializer.joinToString(rule.getExposedHeaders(), ","));
            xmlw.writeEndElement();
            xmlw.writeStartElement("AllowedHeaders");
            xmlw.writeCharacters(ServicePropertiesSerializer.joinToString(rule.getAllowedHeaders(), ","));
            xmlw.writeEndElement();
            xmlw.writeStartElement("MaxAgeInSeconds");
            xmlw.writeCharacters(Integer.toString(rule.getMaxAgeInSeconds()));
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
    }

    private static void writeMetricsProperties(XMLStreamWriter xmlw, MetricsProperties metrics, String metricsName) throws XMLStreamException {
        Utility.assertNotNull("metrics.Configuration", (Object)metrics.getMetricsLevel());
        xmlw.writeStartElement(metricsName);
        xmlw.writeStartElement("Version");
        xmlw.writeCharacters(metrics.getVersion());
        xmlw.writeEndElement();
        xmlw.writeStartElement("Enabled");
        xmlw.writeCharacters(metrics.getMetricsLevel() != MetricsLevel.DISABLED ? "true" : "false");
        xmlw.writeEndElement();
        if (metrics.getMetricsLevel() != MetricsLevel.DISABLED) {
            xmlw.writeStartElement("IncludeAPIs");
            xmlw.writeCharacters(metrics.getMetricsLevel() == MetricsLevel.SERVICE_AND_API ? "true" : "false");
            xmlw.writeEndElement();
        }
        ServicePropertiesSerializer.writeRetentionPolicy(xmlw, metrics.getRetentionIntervalInDays());
        xmlw.writeEndElement();
    }

    private static void writeLoggingProperties(XMLStreamWriter xmlw, LoggingProperties logging) throws XMLStreamException {
        Utility.assertNotNull("logging.LogOperationTypes", logging.getLogOperationTypes());
        xmlw.writeStartElement("Logging");
        xmlw.writeStartElement("Version");
        xmlw.writeCharacters(logging.getVersion());
        xmlw.writeEndElement();
        xmlw.writeStartElement("Delete");
        xmlw.writeCharacters(logging.getLogOperationTypes().contains((Object)LoggingOperations.DELETE) ? "true" : "false");
        xmlw.writeEndElement();
        xmlw.writeStartElement("Read");
        xmlw.writeCharacters(logging.getLogOperationTypes().contains((Object)LoggingOperations.READ) ? "true" : "false");
        xmlw.writeEndElement();
        xmlw.writeStartElement("Write");
        xmlw.writeCharacters(logging.getLogOperationTypes().contains((Object)LoggingOperations.WRITE) ? "true" : "false");
        xmlw.writeEndElement();
        ServicePropertiesSerializer.writeRetentionPolicy(xmlw, logging.getRetentionIntervalInDays());
        xmlw.writeEndElement();
    }

    private static String joinToString(Iterable<?> iterable, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = iterable.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }
}

