/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.trace;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ReadOnlyArrayMap;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.ArrayBasedTraceStateBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.AutoValue_ArrayBasedTraceState;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceState;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceStateBuilder;

@Immutable
@AutoValue
abstract class ArrayBasedTraceState
implements TraceState {
    @Override
    @Nullable
    public String get(String key) {
        if (key == null) {
            return null;
        }
        List<String> entries = this.getEntries();
        for (int i = 0; i < entries.size(); i += 2) {
            if (!entries.get(i).equals(key)) continue;
            return entries.get(i + 1);
        }
        return null;
    }

    @Override
    public int size() {
        return this.getEntries().size() / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        if (consumer == null) {
            return;
        }
        List<String> entries = this.getEntries();
        for (int i = 0; i < entries.size(); i += 2) {
            consumer.accept(entries.get(i), entries.get(i + 1));
        }
    }

    @Override
    public Map<String, String> asMap() {
        return ReadOnlyArrayMap.wrap(this.getEntries());
    }

    abstract List<String> getEntries();

    @Override
    public TraceStateBuilder toBuilder() {
        return new ArrayBasedTraceStateBuilder(this);
    }

    static ArrayBasedTraceState create(List<String> entries) {
        return new AutoValue_ArrayBasedTraceState(entries);
    }

    ArrayBasedTraceState() {
    }
}

