﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/CertificateBasedAuthStatusEnum.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {

/**
 * <p>Describes the properties of the certificate-based authentication you want to
 * use with your WorkSpaces.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CertificateBasedAuthProperties">AWS
 * API Reference</a></p>
 */
class CertificateBasedAuthProperties {
 public:
  AWS_WORKSPACES_API CertificateBasedAuthProperties() = default;
  AWS_WORKSPACES_API CertificateBasedAuthProperties(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API CertificateBasedAuthProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The status of the certificate-based authentication properties.</p>
   */
  inline CertificateBasedAuthStatusEnum GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(CertificateBasedAuthStatusEnum value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CertificateBasedAuthProperties& WithStatus(CertificateBasedAuthStatusEnum value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager
   * Private CA resource.</p>
   */
  inline const Aws::String& GetCertificateAuthorityArn() const { return m_certificateAuthorityArn; }
  inline bool CertificateAuthorityArnHasBeenSet() const { return m_certificateAuthorityArnHasBeenSet; }
  template <typename CertificateAuthorityArnT = Aws::String>
  void SetCertificateAuthorityArn(CertificateAuthorityArnT&& value) {
    m_certificateAuthorityArnHasBeenSet = true;
    m_certificateAuthorityArn = std::forward<CertificateAuthorityArnT>(value);
  }
  template <typename CertificateAuthorityArnT = Aws::String>
  CertificateBasedAuthProperties& WithCertificateAuthorityArn(CertificateAuthorityArnT&& value) {
    SetCertificateAuthorityArn(std::forward<CertificateAuthorityArnT>(value));
    return *this;
  }
  ///@}
 private:
  CertificateBasedAuthStatusEnum m_status{CertificateBasedAuthStatusEnum::NOT_SET};

  Aws::String m_certificateAuthorityArn;
  bool m_statusHasBeenSet = false;
  bool m_certificateAuthorityArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
