/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class XMLEncodingSniffer {
    private static final byte[][] UTF16_MAGIC = new byte[][]{{-2, -1}, {-1, -2}, {0, 60, 0, 63}, {60, 0, 63, 0}};
    private static final byte[][] UCS4_MAGIC = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {0, 0, -1, -2}, {-2, -1, 0, 0}, {0, 0, 0, 60}, {0, 0, 60, 0}, {0, 60, 0, 0}, {60, 0, 0, 0}};
    private static final byte[] UTF8_MAGIC = new byte[]{-17, -69, -65};
    private static final byte[] EBCDIC_MAGIC = new byte[]{76, 111, -89, -108};

    private static boolean matchesMagic(byte[] magic, byte[] buffer) {
        for (int i = 0; i < magic.length; ++i) {
            if (buffer[i] == magic[i]) continue;
            return false;
        }
        return true;
    }

    public static String sniffEncoding(InputStream in) throws IOException {
        int c;
        int asciiLen;
        byte[] buffer = new byte[256];
        in.mark(buffer.length);
        int len = in.read(buffer);
        in.reset();
        if (len < 4) {
            return null;
        }
        for (byte[] magic : UTF16_MAGIC) {
            if (!XMLEncodingSniffer.matchesMagic(magic, buffer)) continue;
            return "UTF-16";
        }
        for (byte[] anUcs4magic : UCS4_MAGIC) {
            if (!XMLEncodingSniffer.matchesMagic(anUcs4magic, buffer)) continue;
            return "UCS-4";
        }
        if (XMLEncodingSniffer.matchesMagic(UTF8_MAGIC, buffer)) {
            return "UTF-8";
        }
        if (XMLEncodingSniffer.matchesMagic(EBCDIC_MAGIC, buffer)) {
            return "EBCDIC";
        }
        for (asciiLen = 0; asciiLen < len && (c = buffer[asciiLen] & 0xFF) != 0 && c <= 127; ++asciiLen) {
        }
        String header = new String(buffer, 0, asciiLen, "ASCII");
        int encIndex = header.indexOf("encoding=");
        if (encIndex < 0) {
            return null;
        }
        if ((encIndex += 9) >= header.length()) {
            return null;
        }
        char quote = header.charAt(encIndex);
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        int encEnd = header.indexOf(quote, encIndex + 1);
        if (encEnd < 0) {
            return null;
        }
        String encoding = header.substring(encIndex + 1, encEnd);
        return encoding.toUpperCase(Locale.ROOT);
    }

    public static boolean hasUTF8BOM(InputStream in) throws IOException {
        byte[] buffer = new byte[3];
        in.mark(buffer.length);
        int len = in.read(buffer);
        in.reset();
        return len == 3 && XMLEncodingSniffer.matchesMagic(UTF8_MAGIC, buffer);
    }

    private XMLEncodingSniffer() {
    }
}

