/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeManagerProvider;
import ghidra.framework.main.ProgramaticUseOnly;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.Component;
import java.rmi.NoSuchObjectException;
import javax.swing.JComponent;

public abstract class MergeManagerPlugin
extends Plugin
implements ProgramaticUseOnly,
DomainObjectListener {
    protected MergeManager mergeManager;
    protected MergeManagerProvider provider;
    protected DomainObject currentDomainObject;
    private boolean domainFileErrorOccurred;

    public MergeManagerPlugin(PluginTool tool, MergeManager mergeManager, DomainObject domainObject) {
        super(tool);
        this.mergeManager = mergeManager;
        this.currentDomainObject = domainObject;
        this.provider = this.createProvider();
        this.addDomainChangeListeners();
    }

    private void addDomainChangeListeners() {
        for (DomainObject dobj : this.getAllOpenDomainObjects()) {
            dobj.addListener((DomainObjectListener)this);
        }
    }

    private void removeDomainChangeListeners() {
        for (DomainObject dobj : this.getAllOpenDomainObjects()) {
            dobj.removeListener((DomainObjectListener)this);
        }
    }

    public abstract MergeManagerProvider createProvider();

    public abstract void processEvent(PluginEvent var1);

    protected void dispose() {
        this.provider.dispose();
        this.removeDomainChangeListeners();
    }

    public static String getDescription() {
        return "Manage merge of Domain Object";
    }

    public static String getDescriptiveName() {
        return "Domain Object Merge Manager";
    }

    public static String getCategory() {
        return "Unmanaged";
    }

    protected boolean canClose() {
        this.provider.cancelCallback(false);
        return false;
    }

    MergeManager getMergeManager() {
        return this.mergeManager;
    }

    void setMergeComponent(JComponent component, String componentID) {
        this.provider.setMergeComponent(component, componentID);
    }

    void removeMergeComponent(JComponent component) {
        this.provider.removeMergeComponent(component);
    }

    void updateMergeDescription(String mergeDescription) {
        this.provider.updateMergeDescription(mergeDescription);
    }

    void updateProgressDetails(String progressDescription) {
        this.provider.updateProgressDetails(progressDescription);
    }

    void setCurrentProgress(int currentPercentProgress) {
        this.provider.setCurrentProgress(currentPercentProgress);
    }

    void showDefaultComponent() {
        this.provider.showDefaultComponent();
    }

    void setApplyEnabled(boolean state) {
        this.provider.setApplyEnabled(state);
    }

    MergeManagerProvider getProvider() {
        return this.provider;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        DomainObjectChangeRecord docr = ev.getChangeRecord(0);
        if (!this.domainFileErrorOccurred && docr.getEventType() == DomainObjectEvent.ERROR) {
            this.domainFileErrorOccurred = true;
            Throwable t = (Throwable)docr.getNewValue();
            String msg = t instanceof NoSuchObjectException ? "Merge is closing due to an unrecoverable error!\nThis error can be caused when your system becomes\nsuspended or due to a server/network problem." : "Merge is closing due to an unrecoverable error!\n \nSuch failures are generally due to an IO Error caused\nby the local filesystem or server.";
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Severe Error Condition", (Object)msg);
            this.provider.cancelCallback(true);
            return;
        }
    }

    public boolean closeAllDomainObjects(boolean ignoreChanges) {
        return false;
    }

    public boolean closeDomainObject() {
        return false;
    }

    public boolean closeDomainObject(DomainObject domainObject, boolean ignoreChanges) {
        return false;
    }

    public DomainObject[] getAllOpenDomainObjects() {
        return new DomainObject[]{this.mergeManager.getDomainObject(0), this.mergeManager.getDomainObject(1), this.mergeManager.getDomainObject(2), this.mergeManager.getDomainObject(3)};
    }

    public DomainObject getCurrentDomainObject() {
        return this.currentDomainObject;
    }

    public int getSearchPriority(DomainObject domainObject) {
        return 0;
    }

    public boolean isVisible(DomainObject domainObject) {
        return false;
    }

    public Program openDomainObject(DomainFile domainFile) {
        return null;
    }

    public Program openDomainObject(DomainFile df, int version) {
        return null;
    }

    public Program openDomainObject(DomainFile domainFile, int version, int state) {
        return null;
    }

    public void openDomainObject(DomainObject domainObject) {
    }

    public void openDomainObject(DomainObject domainObject, boolean current) {
    }

    public void openDomainObject(DomainObject domainObject, int state) {
    }

    public void releaseDomainObject(DomainObject domainObject, Object persistentOwner) {
    }

    public void setCurrentDomainObject(DomainObject domainObject) {
    }

    public boolean setPersistentOwner(DomainObject domainObject, Object owner) {
        return false;
    }

    public void setSearchPriority(DomainObject domainObject, int priority) {
    }
}

