/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.util.exception.CancelledException;
import javax.swing.tree.TreePath;

public class CreateProjectArchiveAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CreateProjectArchiveAction(DataTypeManagerPlugin plugin) {
        super("New Project Data Type Archive", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"New Project Archive..."}, null, "Archive"));
        this.setDescription("Creates a new project data type archive in this data type manager.");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionContext context) {
        try {
            Archive newArchive = this.plugin.getDataTypeManagerHandler().createProjectArchive();
            DataTypeArchiveGTree gTree = this.plugin.getProvider().getGTree();
            this.selectNewArchive(newArchive, gTree);
        }
        catch (CancelledException ce) {
            this.plugin.getTool().setStatusInfo("Create project archive was cancelled.");
        }
    }

    private void selectNewArchive(Archive archive, DataTypeArchiveGTree gTree) {
        GTreeNode root = gTree.getViewRoot();
        gTree.whenNodeIsReady(root, archive.getName(), archiveNode -> {
            gTree.expandPath(root);
            TreePath path = archiveNode.getTreePath();
            gTree.scrollPathToVisible(path);
            gTree.setSelectedNode((GTreeNode)archiveNode);
        });
    }
}

