/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf.DWARFLocation;
import ghidra.app.util.bin.format.dwarf.DWARFLocationList;
import ghidra.app.util.bin.format.dwarf.DWARFName;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionTerminalDerefException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionValueException;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DWARFVariable {
    private final DWARFProgram program;
    private final DWARFFunction dfunc;
    public DWARFName name;
    public DataType type;
    public long lexicalOffset;
    public boolean isOutputParameter;
    public boolean isExternal;
    public boolean isThis;
    public DWARFSourceInfo sourceInfo;
    private List<Varnode> storage = new ArrayList<Varnode>();
    private Varnode stackStorage;
    public String comment;

    public static DWARFVariable fromDataType(DWARFFunction dfunc, DataType dt) {
        return new DWARFVariable(dfunc.getProgram(), dfunc, dt);
    }

    public static DWARFVariable readParameter(DIEAggregate diea, DWARFFunction dfunc, int paramOrdinal) {
        DWARFVariable dvar = new DWARFVariable(dfunc, diea);
        dvar.isOutputParameter = diea.getBool(DWARFAttribute.DW_AT_variable_parameter, false);
        dvar.isThis = paramOrdinal == 0 && DWARFUtil.isThisParam(diea);
        dvar.readParamStorage(diea);
        return dvar;
    }

    public static DWARFVariable readLocalVariable(DIEAggregate diea, DWARFFunction dfunc, long offsetFromFuncStart) {
        DWARFVariable dvar = new DWARFVariable(dfunc, diea);
        dvar.lexicalOffset = offsetFromFuncStart;
        dvar.readLocalVariableStorage(diea);
        return dvar;
    }

    public static DWARFVariable readGlobalVariable(DIEAggregate diea) {
        DWARFVariable dvar = new DWARFVariable(null, diea);
        SymbolType globalVarSymbolType = null;
        dvar.name = dvar.name.replaceType(globalVarSymbolType);
        return dvar.readGlobalStorage(diea) ? dvar : null;
    }

    private DWARFVariable(DWARFProgram program, DWARFFunction dfunc, DataType type) {
        this.program = program;
        this.dfunc = dfunc;
        this.type = type;
    }

    private DWARFVariable(DWARFFunction dfunc, DIEAggregate diea) {
        this.program = diea.getProgram();
        this.dfunc = dfunc;
        this.name = this.program.getName(diea);
        this.type = this.program.getDwarfDTM().getDataTypeForVariable(diea.getTypeRef());
        this.isExternal = diea.getBool(DWARFAttribute.DW_AT_external, false);
        this.sourceInfo = DWARFSourceInfo.create(diea);
    }

    public void setStorage(Varnode varnode) {
        this.clearStorage();
        if (varnode.getSize() == 0) {
            varnode = new Varnode(varnode.getAddress(), this.type.getLength());
        }
        if (DWARFUtil.isStackVarnode(varnode)) {
            this.stackStorage = varnode;
        } else {
            this.storage.add(varnode);
        }
    }

    public void setRamStorage(long offset) {
        this.clearStorage();
        this.addRamStorage(offset);
    }

    public void addRamStorage(long offset) {
        this.storage.add(new Varnode(this.program.getDataAddress(offset), this.type.getLength()));
    }

    public void setStackStorage(long offset) {
        this.clearStorage();
        this.addStackStorage(offset, this.type.getLength());
    }

    public void addStackStorage(long offset, int length) {
        if (this.stackStorage == null) {
            this.stackStorage = new Varnode(this.program.getStackSpace().getAddress(offset), length);
        } else {
            if (this.stackStorage.getOffset() + (long)this.stackStorage.getSize() > offset) {
                throw new IllegalArgumentException("Overlaps previous stack allocation");
            }
            this.stackStorage = new Varnode(this.program.getStackSpace().getAddress(this.stackStorage.getOffset()), (int)(offset - this.stackStorage.getOffset() + (long)length));
        }
    }

    public void setRegisterStorage(List<Register> registers) {
        this.clearStorage();
        this.addRegisterStorage(registers);
    }

    public void addRegisterStorage(List<Register> registers) {
        List<Varnode> varnodes = DWARFUtil.convertRegisterListToVarnodeStorage(registers, this.type.getLength());
        this.storage.addAll(varnodes);
    }

    public boolean isStackStorage() {
        return this.storage.isEmpty() && this.stackStorage != null;
    }

    public long getStackOffset() {
        if (!this.isStackStorage()) {
            throw new IllegalArgumentException();
        }
        return this.stackStorage.getOffset();
    }

    public boolean isRamStorage() {
        return this.storage.size() == 1 && this.storage.get(0).isAddress();
    }

    public Address getRamAddress() {
        return this.isRamStorage() ? this.storage.get(0).getAddress() : null;
    }

    public boolean isMissingStorage() {
        return this.storage.isEmpty() && this.stackStorage == null;
    }

    public boolean isZeroByte() {
        return DWARFUtil.isZeroByteDataType(this.type);
    }

    public boolean isVoidType() {
        return DWARFUtil.isVoid(this.type);
    }

    public boolean isEmptyArray() {
        return DWARFUtil.isEmptyArray(this.type);
    }

    public boolean isLocationValidOnEntry() {
        return this.lexicalOffset == 0L;
    }

    public void clearStorage() {
        this.storage.clear();
        this.stackStorage = null;
    }

    private boolean readParamStorage(DIEAggregate diea) {
        try {
            if (DataTypeComponent.usesZeroLengthComponent((DataType)this.type)) {
                ++this.program.getImportSummary().paramZeroLenDataType;
                this.program.logWarningAt(this.dfunc.address, this.dfunc.name.getName(), "Zero-length function parameter: %s : %s".formatted(this.name.getName(), this.type.getName()));
                return false;
            }
            DWARFLocation paramLoc = diea.getLocation(DWARFAttribute.DW_AT_location, this.dfunc.getEntryPc());
            if (paramLoc == null) {
                return false;
            }
            return this.readStorage(diea, paramLoc, false);
        }
        catch (IOException e) {
            ++diea.getProgram().getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readLocalVariableStorage(DIEAggregate diea) {
        try {
            DWARFLocation location = diea.getLocation(DWARFAttribute.DW_AT_location, this.dfunc.getEntryPc());
            if (location == null) {
                return false;
            }
            if (this.lexicalOffset == 0L) {
                this.lexicalOffset = location.getOffset(this.dfunc.getEntryPc());
            }
            return this.readStorage(diea, location, true);
        }
        catch (IOException e) {
            ++diea.getProgram().getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readGlobalStorage(DIEAggregate diea) {
        DWARFProgram prog = diea.getProgram();
        try {
            DWARFLocationList locList = diea.getLocationList(DWARFAttribute.DW_AT_location);
            DWARFLocation location = locList.getFirstLocation();
            if (location == null) {
                return false;
            }
            DWARFExpressionEvaluator exprEvaluator = new DWARFExpressionEvaluator(diea.getCompilationUnit());
            exprEvaluator.evaluate(location.getExpr());
            Varnode res = exprEvaluator.popVarnode();
            if (!res.isAddress()) {
                Msg.warn((Object)this, (Object)"DWARF: bad location for global variable %s: %s".formatted(this.getDeclInfoString(), exprEvaluator.getExpr().toString()));
                return false;
            }
            if (res.getAddress().getOffset() == 0L) {
                if (diea.hasAttribute(DWARFAttribute.DW_AT_const_value)) {
                    return false;
                }
                prog.getImportSummary().relocationErrorVarDefs.add("%s:%s".formatted(this.name.getNamespacePath().asFormattedString(), this.type.getPathName()));
                return false;
            }
            this.setStorage(res);
            return true;
        }
        catch (DWARFExpressionException e) {
            prog.getImportSummary().addProblematicDWARFExpression(e.getExpression());
            return false;
        }
        catch (IOException e) {
            ++prog.getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readStorage(DIEAggregate diea, DWARFLocation location, boolean allowDerefFixup) {
        if (location == null) {
            return false;
        }
        this.lexicalOffset = location.getOffset(this.dfunc.address.getOffset());
        DWARFProgram prog = diea.getProgram();
        DWARFImportSummary importSummary = prog.getImportSummary();
        DWARFCompilationUnit cu = diea.getCompilationUnit();
        DWARFExpressionEvaluator exprEvaluator = new DWARFExpressionEvaluator(cu);
        if (this.dfunc.funcEntryFrameBaseLoc != null && this.dfunc.funcEntryFrameBaseLoc.getResolvedValue() != null && this.dfunc.funcEntryFrameBaseLoc.contains(this.dfunc.getEntryPc() + this.lexicalOffset)) {
            exprEvaluator.setFrameBaseVal(this.dfunc.funcEntryFrameBaseLoc.getResolvedValue());
        }
        DWARFExpression expr = null;
        try {
            expr = DWARFExpression.read(location.getExpr(), cu);
            if (expr.isEmpty()) {
                return false;
            }
            if (prog.getImportOptions().isUseStaticStackFrameRegisterValue()) {
                exprEvaluator.setValReader(exprEvaluator.withStaticStackRegisterValues(null, prog.getRegisterMappings().getStackFrameRegisterOffset()));
            }
            if (prog.getImportOptions().isShowVariableStorageInfo()) {
                this.comment = expr.toString(cu);
            }
            exprEvaluator.evaluate(expr);
            Varnode storageLoc = exprEvaluator.popVarnode();
            this.setStorage(storageLoc);
            return true;
        }
        catch (DWARFExpressionException e) {
            if (allowDerefFixup && e instanceof DWARFExpressionTerminalDerefException) {
                DWARFExpressionTerminalDerefException derefExcept = (DWARFExpressionTerminalDerefException)e;
                this.type = this.type.getDataTypeManager().getPointer(this.type);
                this.setStorage(derefExcept.getVarnode());
                return true;
            }
            if (e instanceof DWARFExpressionValueException && expr != null) {
                this.comment = expr.toString(cu);
            }
            importSummary.addProblematicDWARFExpression(e.getExpression());
            return false;
        }
    }

    public int getStorageSize() {
        return this.getVarnodes().stream().mapToInt(Varnode::getSize).sum();
    }

    private Varnode[] getVarnodesAsArray() {
        Varnode[] result = new Varnode[this.storage.size() + (this.stackStorage != null ? 1 : 0)];
        this.storage.toArray(result);
        if (this.stackStorage != null) {
            result[this.storage.size()] = this.stackStorage;
        }
        return result;
    }

    public List<Varnode> getVarnodes() {
        ArrayList<Varnode> tmp = new ArrayList<Varnode>(this.storage);
        if (this.stackStorage != null) {
            tmp.add(this.program.isBigEndian() ? tmp.size() : 0, this.stackStorage);
        }
        return tmp;
    }

    public void setVarnodes(List<Varnode> newStorage) {
        Varnode lastNode;
        this.clearStorage();
        this.storage = newStorage;
        Varnode varnode = lastNode = !this.storage.isEmpty() ? this.storage.get(this.storage.size() - 1) : null;
        if (lastNode != null && DWARFUtil.isStackVarnode(lastNode)) {
            this.stackStorage = lastNode;
            this.storage.remove(this.storage.size() - 1);
        }
    }

    public VariableStorage getVariableStorage() throws InvalidInputException {
        Varnode[] varnodes = this.getVarnodesAsArray();
        return varnodes.length != 0 ? new VariableStorage((ProgramArchitecture)this.program.getGhidraProgram(), varnodes) : VariableStorage.UNASSIGNED_STORAGE;
    }

    public Variable asLocalVariable() throws InvalidInputException {
        int firstUseOffset = !this.isStackStorage() ? (int)this.lexicalOffset : 0;
        LocalVariableImpl result = new LocalVariableImpl(this.name.getName(), firstUseOffset, this.type, this.getVariableStorage(), this.program.getGhidraProgram());
        result.setComment(this.comment);
        return result;
    }

    public Parameter asParameter(boolean includeStorageDetail) throws InvalidInputException {
        VariableStorage paramStorage = !this.isMissingStorage() && includeStorageDetail ? this.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE;
        String newName = this.name.isAnon() ? null : this.name.getName();
        ParameterImpl result = new ParameterImpl(newName, -2, this.type, paramStorage, true, this.program.getGhidraProgram(), SourceType.IMPORTED);
        result.setComment(this.getParamComment());
        return result;
    }

    private String getParamComment() {
        if (!this.isOutputParameter) {
            return this.comment;
        }
        return Objects.requireNonNullElse(this.comment, "") + "(Output Parameter)";
    }

    public ParameterDefinition asParameterDef() {
        return new ParameterDefinitionImpl(this.name.getOriginalName(), this.type, this.getParamComment());
    }

    public Parameter asReturnParameter(boolean includeStorageDetail) throws InvalidInputException {
        VariableStorage varStorage = this.isVoidType() ? VariableStorage.VOID_STORAGE : (!this.isMissingStorage() && includeStorageDetail ? this.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE);
        return new ReturnParameterImpl(this.type, varStorage, true, this.program.getGhidraProgram());
    }

    public String getDeclInfoString() {
        return "%s:%s".formatted(this.name.getName(), this.type.getDisplayName());
    }

    public String toString() {
        try {
            return "DWARFVariable [\n\t\tdni=%s,\n\t\ttype=%s,\n\t\tstorage=%s,\n\t\tisOutputParameter=%s\n\t]".formatted(this.name, this.type, this.getVariableStorage().toString(), this.isOutputParameter);
        }
        catch (InvalidInputException e) {
            return "";
        }
    }
}

