/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.ElfInfoProducer;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.NoteGoBuildId;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Map;

public class GolangElfInfoProducer
implements ElfInfoProducer {
    private static final Map<String, ElfInfoItem.ReaderFunc<ElfInfoItem>> GOLANGINFO_READERS = Map.of(".go.buildinfo", GoBuildInfo::read, ".note.go.buildid", NoteGoBuildId::read);
    private ElfLoadHelper elfLoadHelper;

    @Override
    public void init(ElfLoadHelper newElfLoadHelper) {
        this.elfLoadHelper = newElfLoadHelper;
    }

    @Override
    public void markupElfInfo(TaskMonitor monitor) throws CancelledException {
        Program program = this.elfLoadHelper.getProgram();
        for (Map.Entry<String, ElfInfoItem.ReaderFunc<ElfInfoItem>> itemEntry : GOLANGINFO_READERS.entrySet()) {
            monitor.checkCancelled();
            String sectionName = itemEntry.getKey();
            ElfInfoItem.ReaderFunc<ElfInfoItem> readFunc = itemEntry.getValue();
            ElfInfoItem.markupElfInfoItemSection(program, sectionName, readFunc);
        }
    }
}

