/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.DomainFolderOption;
import ghidra.app.util.importer.LibrarySearchPathDummyOption;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.LoadedOpen;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String LINK_EXISTING_OPTION_NAME = "Link Existing Project Libraries";
    static final boolean LINK_EXISTING_OPTION_DEFAULT = true;
    public static final String LINK_SEARCH_FOLDER_OPTION_NAME = "Project Library Search Folder";
    static final String LINK_SEARCH_FOLDER_OPTION_DEFAULT = "";
    public static final String LOAD_LIBRARY_OPTION_NAME = "Load Libraries From Disk";
    static final boolean LOAD_LIBRARY_OPTION_DEFAULT = false;
    public static final String LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME = "Library Search Paths";
    public static final String DEPTH_OPTION_NAME = "Recursive Library Load Depth";
    static final int DEPTH_OPTION_DEFAULT = 1;
    public static final String LIBRARY_DEST_FOLDER_OPTION_NAME = "Library Destination Folder";
    static final String LIBRARY_DEST_FOLDER_OPTION_DEFAULT = "";
    public static final String MIRROR_LAYOUT_OPTION_NAME = "Mirror Library Disk Layout";
    public static final String LOAD_ONLY_LIBRARIES_OPTION_NAME = "Only Load Libraries";
    static final boolean LOAD_ONLY_LIBRARIES_OPTION_DEFAULT = false;

    protected abstract void load(Program var1, Loader.ImporterSettings var2) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(Loader.ImporterSettings settings) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> loadedProgramList = new ArrayList<Loaded<Program>>();
        ArrayList<String> libraryNameList = new ArrayList<String>();
        boolean success = false;
        try {
            Program program = null;
            if (!this.shouldLoadOnlyLibraries(settings)) {
                program = this.doLoad(libraryNameList, settings);
                loadedProgramList.add(new Loaded<Program>(program, settings));
                settings.log().appendMsg("------------------------------------------------\n");
            } else {
                if (settings.project() == null) {
                    throw new LoadException("Cannot load only libraries...project is null");
                }
                String projectPath = FSUtilities.appendPath(settings.projectRootPath(), settings.importName());
                DomainFile domainFile = settings.project().getProjectData().getFile(projectPath);
                if (domainFile == null) {
                    throw new LoadException("Cannot load only libraries for a non-existant program");
                }
                if (!Program.class.isAssignableFrom(domainFile.getDomainObjectClass())) {
                    throw new LoadException("Cannot load only libraries for a non-program");
                }
                program = (Program)domainFile.getOpenedDomainObject(settings.consumer());
                if (program == null) {
                    throw new LoadException("Failed to acquire an open Program");
                }
                loadedProgramList.add(new LoadedOpen<Program>(program, domainFile, FSRL.fromProgram(program), settings.consumer()));
                libraryNameList.addAll(this.getLibraryNames(settings.provider(), program));
            }
            loadedProgramList.addAll(this.loadLibraries(program, libraryNameList, settings));
            success = true;
            ArrayList<Loaded<Program>> arrayList = loadedProgramList;
            return arrayList;
        }
        finally {
            if (!success) {
                loadedProgramList.forEach(Loaded::close);
            }
        }
    }

    @Override
    protected void loadProgramInto(Program program, Loader.ImporterSettings settings) throws CancelledException, LoadException, IOException {
        LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            String message = settings.provider().getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName();
            settings.log().appendMsg(message);
            throw new LoadException(message);
        }
        settings.log().appendMsg("Loading " + settings.provider().getAbsolutePath() + "...");
        this.load(program, settings);
        settings.log().appendMsg("--------------------------------------------------------------------\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) throws CancelledException, IOException {
        List<LibrarySearchPath> searchPaths;
        TaskMonitor monitor = settings.monitor();
        if (loadedPrograms.isEmpty() || !this.isLinkExistingLibraries(settings) && !this.isLoadLibraries(settings)) {
            return;
        }
        List<DomainFolder> searchFolders = this.getLibrarySearchFolders(loadedPrograms, settings);
        Program firstProgram = loadedPrograms.getFirst().getDomainObject(this);
        try {
            searchPaths = this.getLibrarySearchPaths(firstProgram, settings);
        }
        finally {
            firstProgram.release((Object)this);
        }
        List<Loaded<Program>> saveablePrograms = loadedPrograms.stream().filter(loaded -> loaded.check(Predicate.not(DomainObject::isTemporary))).toList();
        monitor.initialize((long)saveablePrograms.size());
        for (Loaded loaded2 : saveablePrograms) {
            monitor.increment();
            Program program = (Program)loaded2.getDomainObject(this);
            try {
                ExternalManager extManager = program.getExternalManager();
                String[] extLibNames = extManager.getExternalLibraryNames();
                if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
                monitor.setMessage("Resolving..." + program.getName());
                int id = program.startTransaction("Resolving external references");
                try {
                    this.resolveExternalLibraries(program, saveablePrograms, searchFolders, searchPaths, settings);
                }
                finally {
                    program.endTransaction(id, true);
                }
            }
            finally {
                program.release((Object)this);
            }
        }
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram, mirrorFsLayout);
        list.add(new Option(LINK_EXISTING_OPTION_NAME, true, Boolean.class, "-loader-linkExistingProjectLibraries"));
        list.add(new DomainFolderOption(LINK_SEARCH_FOLDER_OPTION_NAME, "-loader-projectLibrarySearchFolder", mirrorFsLayout));
        list.add(new Option(LOAD_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadLibraries"));
        list.add(new LibrarySearchPathDummyOption(LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME));
        list.add(new Option(DEPTH_OPTION_NAME, 1, Integer.class, "-loader-libraryLoadDepth"));
        list.add(new DomainFolderOption(LIBRARY_DEST_FOLDER_OPTION_NAME, "-loader-libraryDestinationFolder", mirrorFsLayout));
        list.add(new Option(MIRROR_LAYOUT_OPTION_NAME, Boolean.class, mirrorFsLayout, "-loader-libraryMirrorLayout", null, null, mirrorFsLayout));
        list.add(new Option(LOAD_ONLY_LIBRARIES_OPTION_NAME, Boolean.class, false, "-loader-loadOnlyLibraries", null, null, true));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (name.equals(LINK_EXISTING_OPTION_NAME) || name.equals(LOAD_LIBRARY_OPTION_NAME) || name.equals(MIRROR_LAYOUT_OPTION_NAME) || name.equals(LOAD_ONLY_LIBRARIES_OPTION_NAME)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (name.equals(DEPTH_OPTION_NAME)) {
                    if (Integer.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (!name.equals(LINK_SEARCH_FOLDER_OPTION_NAME) && !name.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) continue;
                if (!String.class.isAssignableFrom(option.getValueClass())) {
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                String value = (String)option.getValue();
                if (value.isEmpty() || value.startsWith("/")) continue;
                return "Invalid absolute project path for option: " + name;
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    protected boolean isLinkExistingLibraries(Loader.ImporterSettings settings) {
        return OptionUtils.getOption(LINK_EXISTING_OPTION_NAME, settings.options(), true);
    }

    protected DomainFolder getLinkSearchFolder(Program program, Loader.ImporterSettings settings) {
        if (!this.shouldSearchAllPaths(program, settings) && !this.isLinkExistingLibraries(settings)) {
            return null;
        }
        if (settings.project() == null) {
            return null;
        }
        ProjectData projectData = settings.project().getProjectData();
        if (settings.mirrorFsLayout()) {
            return projectData.getFolder(settings.projectRootPath());
        }
        String linkSearchFolderPath = OptionUtils.getOption(LINK_SEARCH_FOLDER_OPTION_NAME, settings.options(), "");
        String projectFolderPath = FSUtilities.appendPath(settings.projectRootPath(), settings.importPathOnly());
        if (linkSearchFolderPath.isBlank()) {
            if (projectFolderPath == null) {
                return null;
            }
            return projectData.getFolder(projectFolderPath);
        }
        return projectData.getFolder(FilenameUtils.separatorsToUnix((String)linkSearchFolderPath));
    }

    protected boolean isLoadLibraries(Loader.ImporterSettings settings) {
        return OptionUtils.getOption(LOAD_LIBRARY_OPTION_NAME, settings.options(), false);
    }

    protected boolean isMirroredLayout(Loader.ImporterSettings settings) {
        return OptionUtils.getOption(MIRROR_LAYOUT_OPTION_NAME, settings.options(), settings.mirrorFsLayout());
    }

    protected boolean shouldLoadOnlyLibraries(Loader.ImporterSettings settings) {
        return OptionUtils.getOption(LOAD_ONLY_LIBRARIES_OPTION_NAME, settings.options(), false);
    }

    protected int getLibraryLoadDepth(Loader.ImporterSettings settings) {
        return OptionUtils.getOption(DEPTH_OPTION_NAME, settings.options(), 1);
    }

    protected String getLibraryDestinationFolderPath(Loader.ImporterSettings settings) {
        if (settings.project() == null) {
            return null;
        }
        if (settings.mirrorFsLayout()) {
            return settings.projectRootPath();
        }
        String libraryDestinationFolderPath = OptionUtils.getOption(LIBRARY_DEST_FOLDER_OPTION_NAME, settings.options(), "");
        if (libraryDestinationFolderPath.isBlank()) {
            return settings.projectRootPath();
        }
        return FilenameUtils.separatorsToUnix((String)libraryDestinationFolderPath);
    }

    protected DomainFolder getLibraryDestinationSearchFolder(String libraryDestinationFolderPath, Loader.ImporterSettings settings) {
        if (settings.project() == null || libraryDestinationFolderPath == null) {
            return null;
        }
        if (!this.isLoadLibraries(settings)) {
            return null;
        }
        return settings.project().getProjectData().getFolder(libraryDestinationFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DomainFolder> getLibrarySearchFolders(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) {
        Program firstProgram = loadedPrograms.getFirst().getDomainObject(this);
        try {
            ArrayList<DomainFolder> searchFolders = new ArrayList<DomainFolder>();
            String destPath = this.getLibraryDestinationFolderPath(settings);
            DomainFolder destSearchFolder = this.getLibraryDestinationSearchFolder(destPath, settings);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(firstProgram, settings);
            Optional.ofNullable(destSearchFolder).ifPresent(searchFolders::add);
            Optional.ofNullable(linkSearchFolder).ifPresent(searchFolders::add);
            ArrayList<DomainFolder> arrayList = searchFolders;
            return arrayList;
        }
        finally {
            firstProgram.release((Object)this);
        }
    }

    protected boolean shouldSearchAllPaths(Program program, Loader.ImporterSettings settings) {
        return false;
    }

    protected ByteProvider createLibraryByteProvider(FSRL libFsrl, LoadSpec loadSpec, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        return FileSystemService.getInstance().getByteProvider(libFsrl, true, monitor);
    }

    protected void processLibrary(Program library, String libraryName, FSRL libraryFsrl, Queue<UnprocessedLibrary> unprocessed, int depth, Loader.ImporterSettings settings) throws IOException, CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Loaded<Program>> loadLibraries(Program program, List<String> libraryNameList, Loader.ImporterSettings settings) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> arrayList;
        List<LibrarySearchPath> searchPaths;
        List<LibrarySearchPath> customSearchPaths;
        block8: {
            ByteProvider provider = settings.provider();
            List<Option> options = settings.options();
            MessageLog log = settings.log();
            TaskMonitor monitor = settings.monitor();
            ArrayList<Loaded<Program>> loadedPrograms = new ArrayList<Loaded<Program>>();
            TreeSet<String> processed = new TreeSet<String>(this.getLibraryNameComparator());
            Queue<UnprocessedLibrary> unprocessed = this.createUnprocessedQueue(libraryNameList, settings);
            boolean loadLibraries = this.isLoadLibraries(settings);
            customSearchPaths = this.getCustomLibrarySearchPaths(provider, options, log, monitor);
            searchPaths = this.getLibrarySearchPaths(program, settings);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(program, settings);
            String libraryDestFolderPath = this.getLibraryDestinationFolderPath(settings);
            DomainFolder libraryDestFolder = this.getLibraryDestinationSearchFolder(libraryDestFolderPath, settings);
            boolean success = false;
            try {
                while (!unprocessed.isEmpty()) {
                    monitor.checkCancelled();
                    UnprocessedLibrary unprocessedLibrary = unprocessed.remove();
                    String library = unprocessedLibrary.name().trim();
                    int depth = unprocessedLibrary.depth();
                    if (depth == 0 || processed.contains(library)) continue;
                    processed.add(library);
                    if (this.findLibraryInProject(library, libraryDestFolder, searchPaths, settings) != null) {
                        log.appendMsg("Found %s in %s...".formatted(library, libraryDestFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (this.findLibraryInProject(library, linkSearchFolder, searchPaths, settings) != null) {
                        log.appendMsg("Found %s in %s...".formatted(library, linkSearchFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (!this.isLoadLibraries(settings) && !this.shouldSearchAllPaths(program, settings)) continue;
                    Loaded<Program> loadedLibrary = this.loadLibraryFromSearchPaths(library, customSearchPaths, libraryDestFolderPath, unprocessed, depth, settings);
                    if (loadedLibrary == null) {
                        loadedLibrary = this.loadLibraryFromSearchPaths(library, searchPaths, libraryDestFolderPath, unprocessed, depth, settings);
                    }
                    if (loadedLibrary != null) {
                        boolean temporary = !loadLibraries || unprocessedLibrary.temporary();
                        loadedLibrary.apply(p -> p.setTemporary(temporary));
                        loadedPrograms.add(loadedLibrary);
                        log.appendMsg((String)(temporary ? "Library not saved to project." : "Saving library to: " + String.valueOf(loadedLibrary)));
                    }
                    log.appendMsg("------------------------------------------------\n");
                }
                success = true;
                arrayList = loadedPrograms;
                if (success) break block8;
            }
            catch (Throwable throwable) {
                if (!success) {
                    loadedPrograms.forEach(Loaded::close);
                }
                Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
                    if (!fsSearchPath.fsRef().isClosed()) {
                        fsSearchPath.fsRef().close();
                    }
                });
                FileSystemService.getInstance().closeUnusedFileSystems();
                throw throwable;
            }
            loadedPrograms.forEach(Loaded::close);
        }
        Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
            if (!fsSearchPath.fsRef().isClosed()) {
                fsSearchPath.fsRef().close();
            }
        });
        FileSystemService.getInstance().closeUnusedFileSystems();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Loaded<Program> loadLibraryFromSearchPaths(String library, List<LibrarySearchPath> searchPaths, String libraryDestFolderPath, Queue<UnprocessedLibrary> unprocessed, int depth, Loader.ImporterSettings settings) throws CancelledException, IOException {
        if (searchPaths.isEmpty()) {
            return null;
        }
        List<Option> options = settings.options();
        LoadSpec desiredLoadSpec = settings.loadSpec();
        Object consumer = settings.consumer();
        MessageLog log = settings.log();
        TaskMonitor monitor = settings.monitor();
        log.appendMsg("Searching %d path%s for library %s...".formatted(searchPaths.size(), searchPaths.size() > 1 ? "s" : "", library));
        Program libraryProgram = null;
        boolean success = false;
        try {
            List<GFile> candidateLibraryFiles = this.findLibraryOnDisk(library, searchPaths, log, monitor);
            if (candidateLibraryFiles.isEmpty()) {
                log.appendMsg("Library not found.");
                Loaded<Program> loaded = null;
                return loaded;
            }
            for (GFile candidateLibraryFile : candidateLibraryFiles) {
                Loaded<Program> loaded;
                Loader.ImporterSettings librarySettings;
                ByteProvider provider;
                FSRL candidateLibraryFsrl;
                block18: {
                    LoadSpec libLoadSpec;
                    ArrayList<String> newLibraryList;
                    block17: {
                        monitor.checkCancelled();
                        candidateLibraryFsrl = candidateLibraryFile.getFSRL();
                        newLibraryList = new ArrayList<String>();
                        provider = this.createLibraryByteProvider(candidateLibraryFsrl, desiredLoadSpec, log, monitor);
                        libLoadSpec = this.matchSupportedLoadSpec(settings.loadSpec(), provider);
                        if (libLoadSpec != null) break block17;
                        log.appendMsg("Skipping library which is the wrong architecture: " + String.valueOf(candidateLibraryFsrl));
                        if (provider == null) continue;
                        provider.close();
                        continue;
                    }
                    if (this.isMirroredLayout(settings)) {
                        library = FSUtilities.mirroredProjectPath(candidateLibraryFsrl.getPath());
                    }
                    librarySettings = new Loader.ImporterSettings(provider, library, settings.project(), libraryDestFolderPath, this.isMirroredLayout(settings), libLoadSpec, options, consumer, log, monitor);
                    libraryProgram = this.doLoad(newLibraryList, librarySettings);
                    for (String newLibraryName : newLibraryList) {
                        unprocessed.add(new UnprocessedLibrary(newLibraryName, depth - 1, false));
                    }
                    if (libraryProgram != null) break block18;
                    if (provider == null) continue;
                    provider.close();
                    continue;
                }
                try {
                    this.processLibrary(libraryProgram, library, candidateLibraryFsrl, unprocessed, depth, librarySettings);
                    success = true;
                    loaded = new Loaded<Program>(libraryProgram, librarySettings);
                    if (provider == null) return loaded;
                }
                catch (Throwable throwable) {
                    try {
                        if (provider == null) throw throwable;
                        try {
                            provider.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                provider.close();
                return loaded;
            }
        }
        finally {
            if (!success && libraryProgram != null) {
                libraryProgram.release(consumer);
            }
        }
    }

    protected DomainFile findLibraryInProject(String library, DomainFolder folder, List<LibrarySearchPath> searchPaths, Loader.ImporterSettings settings) throws CancelledException {
        String parentProjectPath;
        if (folder == null) {
            return null;
        }
        ProjectData projectData = folder.getProjectData();
        if (this.isMirroredLayout(settings)) {
            for (LibrarySearchPath searchPath : searchPaths) {
                DomainFile ret;
                settings.monitor().checkCancelled();
                GFileSystem fs = searchPath.fsRef().getFilesystem();
                String fsPath = FSUtilities.mirroredProjectPath(FSUtilities.appendPath(fs.getFSRL().getPath(), searchPath.relativeFsPath()));
                String projectPath = FSUtilities.appendPath(folder.getPathname(), fsPath, library);
                DomainFolder parentFolder = projectData.getFolder(FilenameUtils.getFullPath((String)projectPath));
                if (parentFolder == null || (ret = this.lookupLibraryInFolder(FilenameUtils.getName((String)library), parentFolder)) == null) continue;
                return ret;
            }
            return null;
        }
        if (this.isAbsoluteLibraryPath(library) && (folder = projectData.getFolder(parentProjectPath = FSUtilities.appendPath(folder.getPathname(), FilenameUtils.getFullPath((String)library)))) == null) {
            return null;
        }
        String libraryName = FilenameUtils.getName((String)library);
        DomainFile file = folder.getFile(libraryName);
        if (file != null) {
            return file;
        }
        return this.lookupLibraryInFolder(libraryName, folder);
    }

    protected DomainFile lookupLibraryInFolder(String libraryName, DomainFolder folder) {
        return Arrays.stream(folder.getFiles()).filter(df -> this.getLibraryNameComparator().compare(df.getName(), libraryName) == 0).findFirst().orElse(null);
    }

    private List<GFile> findLibraryOnDisk(String library, List<LibrarySearchPath> searchPaths, MessageLog log, TaskMonitor monitor) throws CancelledException {
        ArrayList<GFile> results = new ArrayList<GFile>();
        try {
            for (LibrarySearchPath searchPath : searchPaths) {
                monitor.checkCancelled();
                String fullLibraryPath = FSUtilities.appendPath(searchPath.relativeFsPath(), library);
                GFileSystem fs = searchPath.fsRef().getFilesystem();
                GFile file = this.lookupLibraryInFs(fullLibraryPath, fs);
                Optional.ofNullable(file).ifPresent(results::add);
            }
            if (results.isEmpty() && this.isAbsoluteLibraryPath(library)) {
                LocalFileSystem localFS = FileSystemService.getInstance().getLocalFS();
                GFile file = this.lookupLibraryInFs(library, localFS);
                Optional.ofNullable(file).ifPresent(results::add);
            }
        }
        catch (IOException e) {
            log.appendException((Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(List<String> libraryNameList, Loader.ImporterSettings settings) throws CancelledException, IOException {
        MessageLog log = settings.log();
        Program program = this.createProgram(settings);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            log.appendMsg("Loading %s...".formatted(settings.provider().getFSRL()));
            this.load(program, settings);
            this.createDefaultMemoryBlocks(program, settings);
            libraryNameList.addAll(this.getLibraryNames(settings.provider(), program));
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, true);
            if (!success) {
                program.release(settings.consumer());
            }
        }
    }

    private List<String> getLibraryNames(ByteProvider provider, Program program) {
        ArrayList<String> libraryNames = new ArrayList<String>();
        ExternalManager extMgr = program.getExternalManager();
        String[] externalNames = extMgr.getExternalLibraryNames();
        Comparator<String> comparator = this.getLibraryNameComparator();
        Arrays.sort(externalNames, comparator);
        for (String name : externalNames) {
            if (comparator.compare(name, provider.getName()) == 0 || comparator.compare(name, program.getName()) == 0 || "<EXTERNAL>".equals(name)) continue;
            libraryNames.add(name);
        }
        return libraryNames;
    }

    private void resolveExternalLibraries(Program program, List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, List<LibrarySearchPath> fsSearchPaths, Loader.ImporterSettings settings) throws CancelledException {
        ExternalManager extManager = program.getExternalManager();
        MessageLog log = settings.log();
        TaskMonitor monitor = settings.monitor();
        String[] extLibNames = extManager.getExternalLibraryNames();
        log.appendMsg("Linking the External Programs of '%s' to imported libraries...".formatted(program.getName()));
        for (String externalLibName : extLibNames) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCancelled();
            try {
                Loaded<Program> match = this.findLibraryInLoadedList(loadedPrograms, externalLibName);
                if (match != null) {
                    extManager.setExternalPath(externalLibName, FSUtilities.appendPath(match.getProjectFolderPath(), match.getName()), false);
                    log.appendMsg("  [" + externalLibName + "] -> [" + match.getName() + "]");
                    continue;
                }
                boolean found = false;
                for (DomainFolder searchFolder : searchFolders) {
                    DomainFile alreadyImportedLib = this.findLibraryInProject(externalLibName, searchFolder, fsSearchPaths, settings);
                    if (alreadyImportedLib == null) continue;
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    log.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    found = true;
                    break;
                }
                if (found) continue;
                log.appendMsg("  [" + externalLibName + "] -> not found in project");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
        log.appendMsg("------------------------------------------------\n");
    }

    private Queue<UnprocessedLibrary> createUnprocessedQueue(List<String> libraryNames, Loader.ImporterSettings settings) {
        int depth = this.getLibraryLoadDepth(settings);
        return libraryNames.stream().map(name -> new UnprocessedLibrary((String)name, depth, false)).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<LibrarySearchPath> getCustomLibrarySearchPaths(ByteProvider provider, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        return List.of();
    }

    protected boolean isValidSearchPath(FSRL fsrl, Loader.ImporterSettings settings) throws CancelledException {
        settings.monitor().checkCancelled();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LibrarySearchPath> getLibrarySearchPaths(Program program, Loader.ImporterSettings settings) throws CancelledException {
        if (!(this.isLoadLibraries(settings) || this.shouldSearchAllPaths(program, settings) || this.isMirroredLayout(settings) && this.isLinkExistingLibraries(settings))) {
            return List.of();
        }
        FileSystemService fsService = FileSystemService.getInstance();
        ArrayList<LibrarySearchPath> result = new ArrayList<LibrarySearchPath>();
        boolean success = false;
        try {
            for (FSRL fsrl : LibrarySearchPathManager.getLibraryFsrlList(program, settings.log(), settings.monitor())) {
                Closeable fileRef;
                if (!this.isValidSearchPath(fsrl, settings)) continue;
                if (fsService.isLocal(fsrl)) {
                    try {
                        if (fsService.getLocalFS().getLocalFile(fsrl).isFile() && (fileRef = fsService.probeFileForFilesystem(fsrl, settings.monitor(), null)) != null) {
                            result.add(new LibrarySearchPath((FileSystemRef)fileRef, null));
                            continue;
                        }
                    }
                    catch (IOException e) {
                        settings.log().appendMsg(e.getMessage());
                    }
                }
                try {
                    fileRef = fsService.getRefdFile(fsrl, settings.monitor());
                    try {
                        if (fileRef == null) continue;
                        result.add(new LibrarySearchPath(((RefdFile)fileRef).fsRef.dup(), ((RefdFile)fileRef).file.getPath()));
                    }
                    finally {
                        if (fileRef == null) continue;
                        ((RefdFile)fileRef).close();
                    }
                }
                catch (IOException e) {
                    settings.log().appendMsg(e.getMessage());
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                result.forEach(fsSearchPath -> fsSearchPath.fsRef().close());
            }
        }
        return result;
    }

    protected Loaded<Program> findLibraryInLoadedList(List<Loaded<Program>> loadedPrograms, String library) {
        return loadedPrograms.stream().filter(e -> this.getLibraryNameComparator().compare(e.getName(), library) == 0).findFirst().orElse(null);
    }

    protected LoadSpec matchSupportedLoadSpec(LoadSpec desiredLoadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair desiredPair = desiredLoadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> supportedLoadSpecs = this.findSupportedLoadSpecs(provider);
        if (supportedLoadSpecs != null) {
            for (LoadSpec supportedLoadSpec : supportedLoadSpecs) {
                if (!desiredPair.equals((Object)supportedLoadSpec.getLanguageCompilerSpec())) continue;
                return supportedLoadSpec;
            }
        }
        return null;
    }

    protected GFile lookupLibraryInFs(String library, GFileSystem fs) throws IOException {
        GFile foundFile = fs.lookup(library, this.getLibraryNameComparator());
        return foundFile != null && !foundFile.isDirectory() ? foundFile : null;
    }

    protected Comparator<String> getLibraryNameComparator() {
        return (s1, s2) -> FilenameUtils.getName((String)s1).compareTo(FilenameUtils.getName((String)s2));
    }

    private boolean isAbsoluteLibraryPath(String path) {
        return FilenameUtils.getPrefixLength((String)path) > 0;
    }

    protected record UnprocessedLibrary(String name, int depth, boolean temporary) {
    }

    protected record LibrarySearchPath(FileSystemRef fsRef, String relativeFsPath) {
    }
}

