/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.CDexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;

public class CdexDebugOffsetTable {
    @Nonnull
    public static void annotate(@Nonnull DexAnnotator annotator, DexBuffer buffer) {
        DexReader<? extends DexBuffer> reader = buffer.readerAt(annotator.getCursor());
        SectionAnnotator debugInfoAnnotator = annotator.getAnnotator(8195);
        int methodCount = annotator.dexFile.getMethodSection().size();
        for (int methodIndex = 0; methodIndex < methodCount; methodIndex += 16) {
            annotator.annotate(0, "Offset chuck for methods %d-%d", methodIndex, Math.min(methodIndex + 16, methodCount));
            annotator.indent();
            int bitmask = reader.readUbyte() << 8;
            bitmask |= reader.readUbyte();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                sb.append(bitmask >> i & 1);
            }
            annotator.annotate(2, "bitmask: 0b%s", sb.reverse());
            int debugOffset = ((CDexBackedDexFile)annotator.dexFile).getDebugInfoBase();
            for (int i = 0; i < 16; ++i) {
                if ((bitmask & 1) != 0) {
                    int offsetDelta = reader.readBigUleb128();
                    annotator.annotateTo(reader.getOffset(), "[method_id: %d]: offset_delta: %d  (offset=0x%x)", methodIndex + i, offsetDelta, debugOffset += offsetDelta);
                    debugInfoAnnotator.setItemIdentity(debugOffset, ((DexBackedMethodReference)annotator.dexFile.getMethodSection().get(methodIndex + i)).toString());
                }
                bitmask >>= 1;
            }
            annotator.deindent();
        }
    }
}

