/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.AttributedGraph;
import java.io.File;
import java.io.IOException;
import org.jgrapht.Graph;
import org.jgrapht.nio.csv.CSVExporter;
import org.jgrapht.nio.csv.CSVFormat;

public class CsvEdgeListGraphExporter
extends AbstractAttributedGraphExporter {
    private static final char CVS_DELIMITER = ',';

    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        CSVExporter exporter = new CSVExporter(this.vertexIdProvider, CSVFormat.EDGE_LIST, ',');
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "csv";
    }

    public String getName() {
        return "CSV:Edge List";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a edge list CSV file";
    }
}

