/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.search;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.plugin.core.search.DecompilerTextFinder;
import ghidra.app.plugin.core.search.TextMatch;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.FunctionNameTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class DecompilerTextFinderTableModel
extends GhidraProgramTableModel<TextMatch> {
    private String searchText;
    private boolean isRegex;
    private AddressSetView selection;
    private int searchLimit;

    protected DecompilerTextFinderTableModel(ServiceProvider serviceProvider, Program program, String searchText, boolean isRegex) {
        super("Decompiler Search", serviceProvider, program, null, true);
        this.searchText = searchText;
        this.isRegex = isRegex;
    }

    void setSelection(AddressSetView selection) {
        this.selection = selection;
    }

    void setSearchLimit(int limit) {
        this.searchLimit = limit;
    }

    protected TableColumnDescriptor<TextMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionNameTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new LineNumberTableColumn(this), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ContextTableColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<TextMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        Pattern pattern;
        AtomicInteger counter = new AtomicInteger();
        Consumer<TextMatch> limitedConsumer = tm -> {
            int count = counter.incrementAndGet();
            if (count >= this.searchLimit) {
                monitor.cancel();
            }
            accumulator.add(tm);
        };
        if (this.isRegex) {
            pattern = Pattern.compile(this.searchText);
        } else {
            String quoted = Pattern.quote(this.searchText);
            pattern = Pattern.compile(quoted, 2);
        }
        DecompilerTextFinder finder = new DecompilerTextFinder();
        if (this.selection != null) {
            FunctionManager functionManager = this.program.getFunctionManager();
            FunctionIterator functions = functionManager.getFunctions(this.selection, true);
            finder.findText(this.program, pattern, (Iterator<Function>)functions, limitedConsumer, monitor);
        } else {
            finder.findText(this.program, pattern, limitedConsumer, monitor);
        }
    }

    public Address getAddress(int row) {
        TextMatch match = (TextMatch)this.getRowObject(row);
        if (match != null) {
            return match.getAddress();
        }
        return null;
    }

    private class LineNumberTableColumn
    extends AbstractProgramBasedDynamicTableColumn<TextMatch, Integer> {
        private LineNumberTableColumn(DecompilerTextFinderTableModel decompilerTextFinderTableModel) {
        }

        public Integer getValue(TextMatch rowObject, Settings settings, Program p, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getLineNumber();
        }

        public String getColumnName() {
            return "Line Number";
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    private class ContextTableColumn
    extends AbstractProgramBasedDynamicTableColumn<TextMatch, LocationReferenceContext> {
        private ContextCellRenderer renderer;

        private ContextTableColumn() {
            this.renderer = new ContextCellRenderer();
        }

        public LocationReferenceContext getValue(TextMatch rowObject, Settings settings, Program p, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getContext();
        }

        public String getColumnName() {
            return "Context";
        }

        public GColumnRenderer<LocationReferenceContext> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ContextCellRenderer
    extends AbstractGhidraColumnRenderer<LocationReferenceContext> {
        private ContextCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            TextMatch match = (TextMatch)data.getRowObject();
            LocationReferenceContext context = match.getContext();
            String text = match.isMultiLine() ? context.getPlainText() : context.getBoldMatchingText();
            this.setText(text);
            return this;
        }

        public String getFilterString(LocationReferenceContext context, Settings settings) {
            return context.getPlainText();
        }
    }
}

