/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private static final String PLUGIN_CONFIG_RESOURCE = "META-INF/vfs-providers.xml";
    private URL configUri;
    private ClassLoader classLoader;

    public void setConfiguration(String configUri) {
        try {
            this.setConfiguration(new URL(configUri));
        }
        catch (MalformedURLException e) {
            this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setConfiguration(URL configUri) {
        this.configUri = configUri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void init() throws FileSystemException {
        DefaultFileReplicator replicator = this.createDefaultFileReplicator();
        this.setReplicator(new PrivilegedFileReplicator(replicator));
        this.setTemporaryFileStore(replicator);
        if (this.configUri == null) {
            URL url = this.getClass().getResource(CONFIG_RESOURCE);
            FileSystemException.requireNonNull(url, "vfs.impl/find-config-file.error", CONFIG_RESOURCE);
            this.configUri = url;
        }
        this.configure(this.configUri);
        this.configurePlugins();
        super.init();
    }

    protected void configurePlugins() throws FileSystemException {
        Enumeration<URL> enumResources;
        try {
            enumResources = this.enumerateResources(PLUGIN_CONFIG_RESOURCE);
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        while (enumResources.hasMoreElements()) {
            this.configure(enumResources.nextElement());
        }
    }

    private ClassLoader findClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        return this.getValidClassLoader(this.getClass());
    }

    protected DefaultFileReplicator createDefaultFileReplicator() {
        return new DefaultFileReplicator();
    }

    private void configure(URL configUri) throws FileSystemException {
        InputStream configStream = null;
        try {
            DocumentBuilder builder = this.createDocumentBuilder();
            configStream = configUri.openStream();
            Element config = builder.parse(configStream).getDocumentElement();
            this.configure(config);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri.toString(), (Throwable)e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    this.getLogger().warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void configure(String configUri, InputStream configStream) throws FileSystemException {
        try {
            this.configure(this.createDocumentBuilder().parse(configStream).getDocumentElement());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/load-config.error", (Object)configUri, (Throwable)e);
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(true);
        return factory.newDocumentBuilder();
    }

    private void configure(Element config) throws FileSystemException {
        NodeList providers = config.getElementsByTagName("provider");
        int count = providers.getLength();
        for (int i = 0; i < count; ++i) {
            Element provider = (Element)providers.item(i);
            this.addProvider(provider, false);
        }
        NodeList operationProviders = config.getElementsByTagName("operationProvider");
        for (int i = 0; i < operationProviders.getLength(); ++i) {
            Element operationProvider = (Element)operationProviders.item(i);
            this.addOperationProvider(operationProvider);
        }
        NodeList defProviders = config.getElementsByTagName("default-provider");
        if (defProviders.getLength() > 0) {
            Element provider = (Element)defProviders.item(0);
            this.addProvider(provider, true);
        }
        NodeList mimeTypes = config.getElementsByTagName("mime-type-map");
        for (int i = 0; i < mimeTypes.getLength(); ++i) {
            Element map = (Element)mimeTypes.item(i);
            this.addMimeTypeMap(map);
        }
        NodeList extensions = config.getElementsByTagName("extension-map");
        for (int i = 0; i < extensions.getLength(); ++i) {
            Element map = (Element)extensions.item(i);
            this.addExtensionMap(map);
        }
    }

    private void addExtensionMap(Element map) {
        String extension = map.getAttribute("extension");
        String scheme = map.getAttribute("scheme");
        if (!StringUtils.isEmpty((CharSequence)scheme)) {
            this.addExtensionMap(extension, scheme);
        }
    }

    private void addMimeTypeMap(Element map) {
        String mimeType = map.getAttribute("mime-type");
        String scheme = map.getAttribute("scheme");
        this.addMimeTypeMap(mimeType, scheme);
    }

    private void addProvider(Element providerDef, boolean isDefault) throws FileSystemException {
        String[] requiredClasses;
        String[] requiredSchemes;
        String classname = providerDef.getAttribute("class-name");
        for (String requiredScheme : requiredSchemes = this.getRequiredSchemes(providerDef)) {
            if (this.hasProvider(requiredScheme)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider-scheme.debug", classname, requiredScheme);
            VfsLog.debug(this.getLogger(), this.getLogger(), msg);
            return;
        }
        for (String requiredClass : requiredClasses = this.getRequiredClasses(providerDef)) {
            if (this.findClass(requiredClass)) continue;
            String msg = Messages.getString("vfs.impl/skipping-provider.debug", classname, requiredClass);
            VfsLog.debug(this.getLogger(), this.getLogger(), msg);
            return;
        }
        FileProvider provider = (FileProvider)this.createInstance(classname);
        String[] schemas = this.getSchemas(providerDef);
        if (schemas.length > 0) {
            this.addProvider(schemas, provider);
        }
        if (isDefault) {
            this.setDefaultProvider(provider);
        }
    }

    private void addOperationProvider(Element providerDef) throws FileSystemException {
        String[] schemas;
        String classname = providerDef.getAttribute("class-name");
        for (String schema : schemas = this.getSchemas(providerDef)) {
            if (!this.hasProvider(schema)) continue;
            FileOperationProvider operationProvider = (FileOperationProvider)this.createInstance(classname);
            this.addOperationProvider(schema, operationProvider);
        }
    }

    private boolean findClass(String className) {
        try {
            this.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element providerDef) {
        ArrayList<String> classes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String className = dep.getAttribute("class-name");
            if (StringUtils.isEmpty((CharSequence)className)) continue;
            classes.add(className);
        }
        return classes.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private String[] getRequiredSchemes(Element providerDef) {
        ArrayList<String> schemes = new ArrayList<String>();
        NodeList deps = providerDef.getElementsByTagName("if-available");
        int count = deps.getLength();
        for (int i = 0; i < count; ++i) {
            Element dep = (Element)deps.item(i);
            String scheme = dep.getAttribute("scheme");
            if (StringUtils.isEmpty((CharSequence)scheme)) continue;
            schemes.add(scheme);
        }
        return schemes.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private String[] getSchemas(Element provider) {
        ArrayList<String> schemas = new ArrayList<String>();
        NodeList schemaElements = provider.getElementsByTagName("scheme");
        int count = schemaElements.getLength();
        for (int i = 0; i < count; ++i) {
            Element scheme = (Element)schemaElements.item(i);
            schemas.add(scheme.getAttribute("name"));
        }
        return schemas.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private ClassLoader getValidClassLoader(Class<?> clazz) {
        return this.validateClassLoader(clazz.getClassLoader(), clazz);
    }

    private ClassLoader validateClassLoader(ClassLoader clazzLoader, Class<?> clazz) {
        return Objects.requireNonNull(clazzLoader, "The class loader for " + clazz + " is null; some Java implementions use null for the bootstrap class loader.");
    }

    private Object createInstance(String className) throws FileSystemException {
        try {
            return this.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-provider.error", (Object)className, (Throwable)e);
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return this.findClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.getValidClassLoader(this.getClass()).loadClass(className);
        }
    }

    private Enumeration<URL> enumerateResources(String name) throws IOException {
        Enumeration<URL> enumeration = this.findClassLoader().getResources(name);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            enumeration = this.getValidClassLoader(this.getClass()).getResources(name);
        }
        return enumeration;
    }
}

