/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LanguageName;

public class CompileFlagsMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 1;
    protected Processor processor;
    protected LanguageName language;
    protected boolean pcodePresent;
    protected int floatingPrecision;
    protected int floatPackage;
    protected int ambiantDataModel;
    protected int ambiantCodeModel;
    protected boolean compiled32BitMode;
    protected String compilerVersionString;

    public CompileFlagsMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.processor = Processor.fromValue(reader.parseUnsignedByteVal());
        byte[] flags = reader.parseBytes(3);
        this.processFlags(flags);
        this.compilerVersionString = reader.parseString(pdb, StringParseType.StringUtf8St);
        pdb.setTargetProcessor(this.processor);
    }

    @Override
    public int getPdbId() {
        return 1;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":\n   Language: ");
        builder.append(this.language.toString());
        builder.append("\n   Target Processor: ");
        builder.append(this.processor.toString());
        builder.append("\n   Floating-point precision: " + this.floatingPrecision);
        builder.append("\n   Floating-point package: " + this.floatPackage);
        builder.append("\n   Ambiant data: " + this.ambiantDataModel);
        builder.append("\n   Ambiant code: " + this.ambiantCodeModel);
        builder.append("\n   PCode present: " + (this.compiled32BitMode ? "yes" : "no"));
        builder.append("\n   Version String:" + this.compilerVersionString);
        builder.append("\n");
    }

    @Override
    protected String getSymbolTypeName() {
        return "COMPILE";
    }

    protected void processFlags(byte[] flagsIn) {
        int flagsByte = flagsIn[0];
        this.language = LanguageName.fromValue(flagsByte);
        flagsByte = flagsIn[1];
        this.pcodePresent = (flagsByte & 1) == 1;
        this.floatingPrecision = (flagsByte >>= 1) & 3;
        this.floatPackage = (flagsByte >>= 2) & 3;
        this.ambiantDataModel = (flagsByte >>= 2) & 7;
        flagsByte = flagsIn[2];
        this.ambiantCodeModel = flagsByte & 7;
        this.compiled32BitMode = ((flagsByte >>= 3) & 1) == 1;
    }
}

