/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.OverlaySpaceDBAdapterV0;
import ghidra.program.database.OverlaySpaceDBAdapterV1;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class OverlaySpaceDBAdapter {
    static String TABLE_NAME = "Overlay Spaces";
    static final Schema SCHEMA = OverlaySpaceDBAdapterV1.SCHEMA_V1;
    static final int OV_SPACE_NAME_COL = 0;
    static final int OV_SPACE_BASE_COL = 1;
    final DBHandle db;

    OverlaySpaceDBAdapter(DBHandle dbHandle) {
        this.db = dbHandle;
    }

    static OverlaySpaceDBAdapter getOverlaySpaceAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        try {
            return new OverlaySpaceDBAdapterV1(dbHandle, openMode);
        }
        catch (VersionException e) {
            if (openMode == OpenMode.UPGRADE) {
                return OverlaySpaceDBAdapter.upgrade(dbHandle, OverlaySpaceDBAdapter.findReadOnlyAdapter(dbHandle), monitor);
            }
            if (e.isUpgradable() && openMode == OpenMode.IMMUTABLE) {
                return OverlaySpaceDBAdapter.findReadOnlyAdapter(dbHandle);
            }
            throw e;
        }
    }

    private static OverlaySpaceDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new OverlaySpaceDBAdapterV0(handle);
        }
        catch (VersionException versionException) {
            throw new VersionException(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OverlaySpaceDBAdapter upgrade(DBHandle dbHandle, OverlaySpaceDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        monitor.setMessage("Upgrading Overlay Table...");
        monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
        DBHandle tmpHandle = dbHandle.getScratchPad();
        try {
            OverlaySpaceDBAdapterV1 tmpAdapter = new OverlaySpaceDBAdapterV1(tmpHandle, OpenMode.CREATE);
            OverlaySpaceDBAdapter.copyRecords(oldAdapter, tmpAdapter, monitor);
            dbHandle.deleteTable(TABLE_NAME);
            OverlaySpaceDBAdapterV1 newAdapter = new OverlaySpaceDBAdapterV1(dbHandle, OpenMode.CREATE);
            OverlaySpaceDBAdapter.copyRecords(tmpAdapter, newAdapter, monitor);
            tmpHandle.deleteTable(TABLE_NAME);
            OverlaySpaceDBAdapterV1 overlaySpaceDBAdapterV1 = newAdapter;
            return overlaySpaceDBAdapterV1;
        }
        finally {
            tmpHandle.deleteTable(TABLE_NAME);
        }
    }

    private static void copyRecords(OverlaySpaceDBAdapter fromAdapter, OverlaySpaceDBAdapter toAdapter, TaskMonitor monitor) throws IOException, CancelledException {
        RecordIterator iter = fromAdapter.getOverlayRecords();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            toAdapter.updateOverlayRecord(rec);
            monitor.incrementProgress(1L);
        }
    }

    final int getRecordCount() {
        Table table = this.db.getTable(TABLE_NAME);
        return table != null ? table.getRecordCount() : 0;
    }

    final void initializeOverlaySpaces(ProgramAddressFactory factory) throws IOException {
        RecordIterator it = this.getOverlayRecords();
        while (it.hasNext()) {
            DBRecord rec = it.next();
            try {
                String spaceName = rec.getString(0);
                if (factory.getAddressSpace(spaceName) != null) {
                    throw new DuplicateNameException("Overlay space '" + spaceName + "' duplicates name of another address space");
                }
                String baseSpaceName = rec.getString(1);
                AddressSpace space = factory.getAddressSpace(baseSpaceName);
                if (space == null) {
                    throw new RuntimeException("Overlay base space '" + baseSpaceName + "' not found for overlay space '" + spaceName + "'");
                }
                factory.addOverlaySpace(rec.getKey(), spaceName, space);
            }
            catch (Exception e) {
                throw new IOException("Unexpected error initializing overlay address spaces", e);
            }
        }
    }

    abstract RecordIterator getOverlayRecords() throws IOException;

    abstract void updateOverlayRecord(DBRecord var1) throws IOException;

    abstract ProgramOverlayAddressSpace createOverlaySpace(ProgramAddressFactory var1, String var2, AddressSpace var3) throws IOException, DuplicateNameException, InvalidNameException;

    abstract boolean removeOverlaySpace(String var1) throws IOException;

    abstract boolean renameOverlaySpace(String var1, String var2) throws IOException;

    abstract void updateOverlaySpaces(ProgramAddressFactory var1) throws IOException;

    abstract void setLanguage(Language var1, ProgramAddressFactory var2, LanguageTranslator var3) throws IOException;
}

