/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.jparted.lib.ps.PartitionSystemHandlerFactory;
import org.catacombae.jparted.lib.ps.apm.APMHandlerFactory;
import org.catacombae.jparted.lib.ps.ebr.EBRHandlerFactory;
import org.catacombae.jparted.lib.ps.gpt.GPTHandlerFactory;
import org.catacombae.jparted.lib.ps.mbr.MBRHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PartitionSystemType {
    MBR(true, MBRHandlerFactory.class),
    GPT(true, GPTHandlerFactory.class),
    APM(true, APMHandlerFactory.class),
    DOS_EXTENDED(false, EBRHandlerFactory.class);

    private final boolean isTopLevelCapable;
    private LinkedList<Class<? extends PartitionSystemHandlerFactory>> factoryClasses = new LinkedList();

    private PartitionSystemType(boolean pIsTopLevelCapable) {
        this.isTopLevelCapable = pIsTopLevelCapable;
    }

    private PartitionSystemType(boolean pIsTopLevelCapable, Class<? extends PartitionSystemHandlerFactory> pDefaultFactoryClass) {
        this(pIsTopLevelCapable);
        this.factoryClasses.addLast(pDefaultFactoryClass);
    }

    public boolean isTopLevelCapable() {
        return this.isTopLevelCapable;
    }

    public void addFactoryClass(Class<? extends PartitionSystemHandlerFactory> pFactoryClass) {
        this.factoryClasses.addLast(pFactoryClass);
    }

    public List<Class<? extends PartitionSystemHandlerFactory>> getFactoryClasses() {
        return new ArrayList<Class<? extends PartitionSystemHandlerFactory>>(this.factoryClasses);
    }

    public PartitionSystemHandlerFactory createDefaultHandlerFactory() {
        if (this.factoryClasses.size() == 0) {
            return null;
        }
        Class<? extends PartitionSystemHandlerFactory> factoryClass = this.factoryClasses.getFirst();
        return PartitionSystemType.createHandlerFactory(factoryClass);
    }

    public static PartitionSystemHandlerFactory createHandlerFactory(Class<? extends PartitionSystemHandlerFactory> factoryClass) {
        try {
            Constructor<? extends PartitionSystemHandlerFactory> c = factoryClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

