/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.framework.store.ItemCheckoutStatus;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

class CheckoutsTableModel
extends AbstractSortedTableModel<ItemCheckoutStatus> {
    private static final long serialVersionUID = 1L;
    static final String DATE = "Checkout Date";
    static final String VERSION = "Version";
    static final String USER = "User";
    static final String HOST = "Hostname";
    static final String PROJECT_NAME = "Project Name";
    static final String PROJECT_LOC = "Location";
    static final int DATE_COL = 0;
    static final int VERSION_COL = 1;
    static final int USER_COL = 2;
    static final int HOST_COL = 3;
    static final int PROJECT_NAME_COL = 4;
    static final int PROJECT_LOC_COL = 5;
    private String[] columnNames = new String[]{"Checkout Date", "Version", "User", "Hostname", "Project Name", "Location"};
    private ItemCheckoutStatus[] statusItems;

    CheckoutsTableModel(ItemCheckoutStatus[] status) {
        this.statusItems = status;
    }

    public String getName() {
        return "Checkouts";
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        if (this.statusItems != null) {
            return this.statusItems.length;
        }
        return 0;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Date.class;
        }
        if (columnIndex == 1) {
            return Integer.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    void refresh(ItemCheckoutStatus[] status) {
        this.statusItems = status;
        this.fireTableDataChanged();
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public List<ItemCheckoutStatus> getModelData() {
        return Arrays.asList(this.statusItems);
    }

    public Object getColumnValueForRow(ItemCheckoutStatus t, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new Date(t.getCheckoutTime());
            }
            case 1: {
                return t.getCheckoutVersion();
            }
            case 2: {
                return t.getUser();
            }
            case 3: {
                return t.getUserHostName();
            }
            case 4: {
                String name = t.getProjectName();
                return name != null ? name : "";
            }
            case 5: {
                String location = t.getProjectLocation();
                return location != null ? location : "";
            }
        }
        return null;
    }
}

