/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.LocationPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.ValueLocation;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class LocationPcodeExecutorStatePiece
implements PcodeExecutorStatePiece<byte[], ValueLocation> {
    private final Language language;
    private final LocationPcodeArithmetic arithmetic;
    private final BytesPcodeArithmetic addressArithmetic;
    private final Map<Long, ValueLocation> unique;

    public LocationPcodeExecutorStatePiece(Language language) {
        this.language = language;
        boolean isBigEndian = language.isBigEndian();
        this.arithmetic = LocationPcodeArithmetic.forEndian(isBigEndian);
        this.addressArithmetic = BytesPcodeArithmetic.forEndian(isBigEndian);
        this.unique = new HashMap<Long, ValueLocation>();
    }

    protected LocationPcodeExecutorStatePiece(Language language, BytesPcodeArithmetic addressArithmetic, Map<Long, ValueLocation> unique) {
        this.language = language;
        this.arithmetic = LocationPcodeArithmetic.forEndian(language.isBigEndian());
        this.addressArithmetic = addressArithmetic;
        this.unique = unique;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<byte[]> getAddressArithmetic() {
        return this.addressArithmetic;
    }

    @Override
    public PcodeArithmetic<ValueLocation> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return Stream.of(this);
    }

    public LocationPcodeExecutorStatePiece fork(PcodeStateCallbacks cb) {
        return new LocationPcodeExecutorStatePiece(this.language, this.addressArithmetic, new HashMap<Long, ValueLocation>(this.unique));
    }

    @Override
    public void setVar(AddressSpace space, byte[] offset, int size, boolean quantize, ValueLocation val) {
        if (!space.isUniqueSpace()) {
            return;
        }
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.STORE);
        this.unique.put(lOffset, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, byte[] offset, int size, ValueLocation val) {
        this.setVar(space, offset, size, false, val);
    }

    @Override
    public ValueLocation getVar(AddressSpace space, byte[] offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        if (!space.isUniqueSpace()) {
            return ValueLocation.fromVarnode(space.getAddress(lOffset), size);
        }
        return this.unique.get(lOffset);
    }

    @Override
    public ValueLocation getVarInternal(AddressSpace space, byte[] offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.getVar(space, offset, size, false, reason);
    }

    @Override
    public Map<Register, ValueLocation> getRegisterValues() {
        return Map.of();
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make 'location' concrete buffers", purpose);
    }

    @Override
    public void clear() {
        this.unique.clear();
    }
}

