/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorIntSdiv
extends BinaryOpBehavior {
    public OpBehaviorIntSdiv() {
        super(34);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (in2 == 0L) {
            throw new LowlevelError("Divide by 0");
        }
        long num = in1;
        long denom = in2;
        num = Utils.zzz_sign_extend((long)num, (int)(8 * sizein - 1));
        denom = Utils.zzz_sign_extend((long)denom, (int)(8 * sizein - 1));
        long sres = num / denom;
        sres = Utils.zzz_zero_extend((long)sres, (int)(8 * sizeout - 1));
        return sres;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in2.signum() == 0) {
            throw new LowlevelError("Divide by 0");
        }
        in1 = Utils.convertToSignedValue((BigInteger)in1, (int)sizein);
        in2 = Utils.convertToSignedValue((BigInteger)in2, (int)sizein);
        return in1.divide(in2);
    }
}

