/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import java.util.ArrayList;
import java.util.List;

class BlockStmt
extends AbstractStmt {
    List<AbstractStmt> children = new ArrayList<AbstractStmt>();

    protected BlockStmt(StructuredSleigh ctx, Runnable body) {
        super(ctx);
        ctx.stack.push(this);
        body.run();
        ctx.stack.pop();
    }

    public void addChild(AbstractStmt child) {
        this.children.add(child);
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        if (this.children.isEmpty()) {
            return next.genGoto(fall);
        }
        StringTree st = new StringTree();
        for (AbstractStmt c : this.children.subList(0, this.children.size() - 1)) {
            st.append(c.generate(this.ctx.FALL, this.ctx.FALL));
        }
        st.append(this.children.get(this.children.size() - 1).generate(next, fall));
        return st;
    }

    @Override
    protected boolean isSingleGoto() {
        return this.children.size() == 1 && this.children.get(0).isSingleGoto();
    }

    @Override
    protected StructuredSleigh.Label getNext() {
        return this.children.isEmpty() ? this.ctx.FALL : this.children.get(this.children.size() - 1).getNext();
    }
}

