/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoExtractProgramBuilder;
import ghidra.app.util.opinion.MachoLoader;
import ghidra.file.formats.ios.dyldcache.DyldCacheExtractor;
import ghidra.file.formats.ios.dyldcache.DyldCacheFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class DyldCacheExtractLoader
extends MachoLoader {
    public static final String DYLD_CACHE_EXTRACT_NAME = "Extracted DYLD Component";
    static final String LIBOBJC_OPTION_NAME = "Add libobjc.dylib";
    static final boolean LIBOBJC_OPTION_DEFAULT = true;
    static final String AUTH_DATA_OPTION_NAME = "Add AUTH_DATA";
    static final boolean AUTH_DATA_OPTION_DEFAULT = false;
    static final String DIRTY_DATA_OPTION_NAME = "Add DIRTY_DATA";
    static final boolean DIRTY_DATA_OPTION_DEFAULT = false;
    static final String CONST_DATA_OPTION_NAME = "Add CONST_DATA";
    static final boolean CONST_DATA_OPTION_DEFAULT = true;
    static final String TEXT_STUBS_OPTION_NAME = "Add TEXT_STUBS";
    static final boolean TEXT_STUBS_OPTION_DEFAULT = true;
    static final String CONFIG_DATA_OPTION_NAME = "Add CONFIG_DATA";
    static final boolean CONFIG_DATA_OPTION_DEFAULT = false;
    static final String READ_ONLY_DATA_OPTION_NAME = "Add READ_ONLY_DATA";
    static final boolean READ_ONLY_DATA_OPTION_DEFAULT = true;
    static final String CONST_TPRO_DATA_OPTION_NAME = "Add CONST_TPRO_DATA";
    static final boolean CONST_TPRO_DATA_OPTION_DEFAULT = false;

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        if (provider.length() >= (long)DyldCacheExtractor.FOOTER_V1.length && Arrays.equals(DyldCacheExtractor.FOOTER_V1, provider.readBytes(provider.length() - (long)DyldCacheExtractor.FOOTER_V1.length, (long)DyldCacheExtractor.FOOTER_V1.length))) {
            return super.findSupportedLoadSpecs(provider);
        }
        return List.of();
    }

    public void load(Program program, Loader.ImporterSettings settings) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)settings.provider(), (TaskMonitor)settings.monitor());
            MachoExtractProgramBuilder.buildProgram(program, settings.provider(), fileBytes, false, settings.log(), settings.monitor());
            this.addOptionalComponents(program, settings.options(), settings.log(), settings.monitor());
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void loadProgramInto(Program program, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        FSRL fsrl = settings.provider().getFSRL();
        Group[] children = program.getListing().getDefaultRootModule().getChildren();
        if (Arrays.stream(children).anyMatch(e -> e.getName().contains(fsrl.getPath()))) {
            settings.log().appendMsg("%s has already been added".formatted(fsrl.getPath()));
            return;
        }
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)settings.provider(), (TaskMonitor)settings.monitor());
            MachoExtractProgramBuilder.buildProgram(program, settings.provider(), fileBytes, true, settings.log(), settings.monitor());
            this.addOptionalComponents(program, settings.options(), settings.log(), settings.monitor());
        }
        catch (CancelledException e2) {
            return;
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new IOException(e4);
        }
    }

    public boolean supportsLoadIntoProgram(Program program) {
        return DYLD_CACHE_EXTRACT_NAME.equals(program.getExecutableFormat());
    }

    public String getName() {
        return DYLD_CACHE_EXTRACT_NAME;
    }

    public int getTierPriority() {
        return 49;
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(LIBOBJC_OPTION_NAME, (Object)(!loadIntoProgram ? 1 : 0), Boolean.class, "-loader-libobjc"));
        if (!loadIntoProgram) {
            // empty if block
        }
        list.add(new Option(AUTH_DATA_OPTION_NAME, (Object)false, Boolean.class, "-loader-authData"));
        if (!loadIntoProgram) {
            // empty if block
        }
        list.add(new Option(DIRTY_DATA_OPTION_NAME, (Object)false, Boolean.class, "-loader-dirtyData"));
        list.add(new Option(CONST_DATA_OPTION_NAME, (Object)(!loadIntoProgram ? 1 : 0), Boolean.class, "-loader-constData"));
        list.add(new Option(TEXT_STUBS_OPTION_NAME, (Object)(!loadIntoProgram ? 1 : 0), Boolean.class, "-loader-textStubs"));
        if (!loadIntoProgram) {
            // empty if block
        }
        list.add(new Option(CONFIG_DATA_OPTION_NAME, (Object)false, Boolean.class, "-loader-configData"));
        list.add(new Option(READ_ONLY_DATA_OPTION_NAME, (Object)(!loadIntoProgram ? 1 : 0), Boolean.class, "-loader-readOnlyData"));
        if (!loadIntoProgram) {
            // empty if block
        }
        list.add(new Option(CONST_TPRO_DATA_OPTION_NAME, (Object)false, Boolean.class, "-loader-constTproData"));
        return list;
    }

    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(LIBOBJC_OPTION_NAME) && !name.equals(AUTH_DATA_OPTION_NAME) && !name.equals(DIRTY_DATA_OPTION_NAME) && !name.equals(CONST_DATA_OPTION_NAME) && !name.equals(TEXT_STUBS_OPTION_NAME) && !name.equals(CONFIG_DATA_OPTION_NAME) && !name.equals(READ_ONLY_DATA_OPTION_NAME) && !name.equals(CONST_TPRO_DATA_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
            }
        }
        return null;
    }

    protected boolean isLoadLibraries(Loader.ImporterSettings settings) {
        return false;
    }

    protected boolean shouldSearchAllPaths(Program program, Loader.ImporterSettings settings) {
        return false;
    }

    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) throws CancelledException, IOException {
    }

    private void addOptionalComponents(Program program, List<Option> options, MessageLog log, TaskMonitor monitor) throws Exception {
        boolean addLibobjc = (Boolean)OptionUtils.getOption((String)LIBOBJC_OPTION_NAME, options, (Object)true);
        long flags = 0L;
        if (((Boolean)OptionUtils.getOption((String)AUTH_DATA_OPTION_NAME, options, (Object)false)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_MAPPING_AUTH_DATA;
        }
        if (((Boolean)OptionUtils.getOption((String)DIRTY_DATA_OPTION_NAME, options, (Object)false)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_MAPPING_DIRTY_DATA;
        }
        if (((Boolean)OptionUtils.getOption((String)CONST_DATA_OPTION_NAME, options, (Object)true)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_MAPPING_CONST_DATA;
        }
        if (((Boolean)OptionUtils.getOption((String)TEXT_STUBS_OPTION_NAME, options, (Object)true)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_MAPPING_TEXT_STUBS;
        }
        if (((Boolean)OptionUtils.getOption((String)CONFIG_DATA_OPTION_NAME, options, (Object)false)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_DYNAMIC_CONFIG_DATA;
        }
        if (((Boolean)OptionUtils.getOption((String)READ_ONLY_DATA_OPTION_NAME, options, (Object)true)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_READ_ONLY_DATA;
        }
        if (((Boolean)OptionUtils.getOption((String)CONST_TPRO_DATA_OPTION_NAME, options, (Object)false)).booleanValue()) {
            flags |= DyldCacheMappingAndSlideInfo.DYLD_CACHE_MAPPING_CONST_TPRO_DATA;
        }
        if (!addLibobjc && flags == 0L) {
            return;
        }
        try (FileSystemRef fsRef = DyldCacheExtractLoader.openDyldCache(program, monitor);){
            DyldCacheFileSystem fs = (DyldCacheFileSystem)fsRef.getFilesystem();
            HashSet<GFile> files = new HashSet<GFile>();
            if (addLibobjc) {
                Optional.ofNullable(fs.lookup("/usr/lib/libobjc.A.dylib")).ifPresent(files::add);
            }
            files.addAll(fs.getFiles(flags));
            for (GFile file : files) {
                Group[] children = program.getListing().getDefaultRootModule().getChildren();
                if (Arrays.stream(children).anyMatch(e -> e.getName().contains(file.getPath()))) {
                    log.appendMsg("%s has already been added".formatted(file.getPath()));
                    continue;
                }
                ByteProvider p = fs.getByteProvider(file, monitor);
                FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)p, (TaskMonitor)monitor);
                MachoExtractProgramBuilder.buildProgram(program, p, fileBytes, true, log, monitor);
            }
        }
    }

    public static FileSystemRef openDyldCache(Program program, TaskMonitor monitor) throws IOException, CancelledException {
        FSRL fsrl = FSRL.fromProgram((Program)program);
        if (fsrl == null) {
            throw new IOException("The program does not have an FSRL property");
        }
        String requiredProtocol = "dyldcachev1";
        if (!fsrl.getFS().getProtocol().equals(requiredProtocol)) {
            throw new IOException("The program's FSRL protocol is '%s' but '%s' is required".formatted(fsrl.getFS().getProtocol(), requiredProtocol));
        }
        FSRLRoot fsrlRoot = fsrl.getFS();
        return FileSystemService.getInstance().getFilesystem(fsrlRoot, monitor);
    }
}

