/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.cramfs.CramFsInfo;
import ghidra.file.formats.cramfs.CramFsInode;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CramFsSuper
implements StructConverter {
    private int magic;
    private int size;
    private int flags;
    private int future;
    private boolean isLE;
    private String signature;
    private CramFsInfo fsid;
    private String name;
    private CramFsInode root;
    private List<CramFsInode> childList = new ArrayList<CramFsInode>();

    public CramFsSuper(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.size = reader.readNextInt();
        this.flags = reader.readNextInt();
        this.future = reader.readNextInt();
        this.signature = reader.readNextAsciiString(16);
        this.fsid = new CramFsInfo(reader);
        this.name = reader.readNextAsciiString(16);
        this.root = new CramFsInode(reader);
        this.isLE = reader.isLittleEndian();
        for (int i = 0; i < this.fsid.getFiles() - 1; ++i) {
            this.childList.add(new CramFsInode(reader));
        }
    }

    public boolean isExtensionsBlockPointerFlagEnabled() {
        return (this.flags & 0x800) == 2048;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFuture() {
        return this.future;
    }

    public boolean isLittleEndian() {
        return this.isLE;
    }

    public String getSignature() {
        return this.signature;
    }

    public CramFsInfo getFsid() {
        return this.fsid;
    }

    public String getName() {
        return this.name;
    }

    public CramFsInode getRoot() {
        return this.root;
    }

    public List<CramFsInode> getChildList() {
        return this.childList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("cramfs_super", 0);
        struct.add(DWORD, "magic", null);
        struct.add(DWORD, "size", null);
        struct.add(DWORD, "flags", null);
        struct.add(DWORD, "future", null);
        struct.add(STRING, 16, "signature", null);
        struct.add(this.fsid.toDataType(), "fsid", null);
        struct.add(STRING, 16, "name", null);
        struct.add(this.root.toDataType(), "root", null);
        return struct;
    }
}

