/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.property;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.property.TracePropertyMapOperations;
import ghidra.trace.util.TraceRegisterUtils;
import java.util.Collection;
import java.util.Map;

public interface TracePropertyMapSpace<T>
extends TracePropertyMapOperations<T> {
    public Trace getTrace();

    public AddressSpace getAddressSpace();

    default public void set(TracePlatform platform, Lifespan lifespan, Register register, T value) {
        AddressRange range = platform.getConventionalRegisterRange(this.getAddressSpace(), register);
        this.set(lifespan, range, value);
    }

    default public void set(Lifespan lifespan, Register register, T value) {
        this.set(this.getTrace().getPlatformManager().getHostPlatform(), lifespan, register, value);
    }

    default public Collection<Map.Entry<TraceAddressSnapRange, T>> getEntries(TracePlatform platform, Lifespan lifespan, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getAddressSpace(), register);
        return this.getEntries(lifespan, range);
    }

    default public Collection<Map.Entry<TraceAddressSnapRange, T>> getEntries(Lifespan lifespan, Register register) {
        return this.getEntries(this.getTrace().getPlatformManager().getHostPlatform(), lifespan, register);
    }

    default public void clear(Lifespan span, Register register) {
        this.clear(span, TraceRegisterUtils.rangeForRegister(register));
    }
}

